/**
 * TextInputReader.cpp
 * Implementation of the TextInputReader class.
 *
 * @author Matija Tomaskovic
 * @version 04-Jun-2001
 */


#include "TextInputReader.h"
#include "MemoryManager.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TextInputReader::TextInputReader(InputStream* pInputStream) {
	this->pInputStream = pInputStream;
	iLine = 1;
	iColumn = 0;
}


TextInputReader::~TextInputReader() {
}


void TextInputReader::SkipSpacesAndEOL() {
    while(TRUE) {
        int iChar = ReadChar();
        if (iChar == -1)
            return;
        if ((iChar == ' ') || (iChar == 13) || (iChar == 10))
			continue;
        PushBack(iChar);
        return;
    }

}

void TextInputReader::SkipSpaces() {
    while(TRUE) {
        int iChar = ReadChar();
        if (iChar == -1)
            return;
        if (iChar == ' ')
            continue;
        PushBack(iChar);
        return;
    }

}


void TextInputReader::SkipUntilEOL() {
    while(TRUE) {
        int iChar = ReadChar();
        if (iChar == -1)
            return;
        if (iChar == 13) {
            iChar = ReadChar();
            if ((iChar) != 10)
                PushBack(iChar);
            return;
        }
        if (iChar == 10)
            return;
    }
}

/**
 * @return FALSE if no more data
 */
BOOL TextInputReader::ReadNextWord() {
	SkipSpacesAndEOL();
	int l = iLine;
	int c = iColumn;
    strLastWord.Set("");
    while(TRUE) {
        int iChar = ReadChar();
        if (iChar == -1) 
			break;
        if ((iChar == ' ') || (iChar == 13) || (iChar == 10)) {
            PushBack(iChar);
			break;
        }
        strLastWord.Append((char) iChar);
    }
	if (strLastWord.GetLength() == 0) {
		char cb[1024];
		wsprintf(cb, "Line %d, Column %d: Word expected", l, c);
		Error(cb);
		return FALSE;
	}
	else
		return TRUE;
}


BOOL TextInputReader::ReadWordUntilDelimiter(char cDelimiter) {
	int l = iLine;
	int c = iColumn;
    strLastWord.Set("");
    int iChar = ReadChar();
    if (iChar == -1)
        return FALSE;
    PushBack(iChar);
    while(TRUE) {
        iChar = ReadChar();
		if (iChar == -1)
			break;
        if ((iChar == cDelimiter) || (iChar == ' ') ||
            (iChar == 13) || (iChar == 10))
        {
			if (iChar != -1)
				PushBack(iChar);
            break;
        }
        strLastWord.Append((char) iChar);
    }

	if (strLastWord.GetLength() == 0) {
		char cb[1024];
		wsprintf(cb, "Line %d, Column %d: Word expected", l, c);
		Error(cb);
		return FALSE;
	}
	else
		return TRUE;
}


/**
 * @return FALSE if no more data (in file or in current line)
 */
BOOL TextInputReader::ReadNextWordInLine() {
	SkipSpaces();
	int l = iLine;
	int c = iColumn;
    strLastWord.Set("");
    // Has more data?
    int iChar = ReadChar();
    if (iChar == -1)
        return FALSE;
    PushBack(iChar);
    while(TRUE) {
        iChar = ReadChar();
        if (iChar == -1)
            return TRUE;
        if ((iChar == ' ') || (iChar == 13) || (iChar == 10)) {
            PushBack(iChar);
            break;
        }
        strLastWord.Append((char) iChar);
    }
	if (strLastWord.GetLength() == 0) {
		char cb[1024];
		wsprintf(cb, "Line %d, Column %d: Word expected", l, c);
		Error(cb);
		return FALSE;
	}
	else
		return TRUE;
}


BOOL TextInputReader::ReadNextWord(char* pszExpectedWord) {
	int l = iLine;
	int c = iColumn;
    if (!ReadNextWord()) {
		char cb[1024];
		wsprintf(cb, "Line %d, Column %d: Word '%s' not found", 
			l, c, pszExpectedWord);
		Error(cb);
		return FALSE;
	}
	else {
		if (!strLastWord.Equals(pszExpectedWord)) {
			char cb[1024];
			wsprintf(cb, "Line %d, Column %d: Word '%s' expected", 
				l, c, pszExpectedWord);
			Error(cb);
			return FALSE;
		}
		else
			return TRUE;
	}
}

BOOL TextInputReader::ReadNextWordInLine(char* pszExpectedWord) {
	int l = iLine;
	int c = iColumn;
    if (!ReadNextWordInLine()) {
		char cb[1024];
		wsprintf(cb, "Line %d, Column %d: Word '%s' not found", 
			l, c, pszExpectedWord);
		Error(cb);
		return FALSE;
	}
    if (!strLastWord.Equals(pszExpectedWord)) {
			char cb[1024];
			wsprintf(cb, "Line %d, Column %d: Word '%s' expected", 
				l, c, pszExpectedWord);
			Error(cb);
			return FALSE;
	}
	else {
		return TRUE;
	}
}


void TextInputReader::PushBack(int iChar) {
    pInputStream->PushBack(iChar);
	if (iChar == 10) {
		iColumn = 0;
	}
	else if (iChar == 13) {
		iLine--;
	}
	else {
		iColumn--;
	}
}

void TextInputReader::PushBack(BYTE* pBuffer, int iSize) {
	for (int i=iSize-1; i>=0; i--)
		PushBack(pBuffer[i]);
}

BOOL TextInputReader::ReadNextChar(char c) {
	int line = iLine;
	int col = iColumn;
    int iChar = ReadChar();
	char cc = iChar;
	if (c != cc) {
		char cb[1024];
		wsprintf(cb, "Line %d, Column %d: Char '%c' expected", 
			line, col, c);
		Error(cb);
		return FALSE;
	}
	else {
		return TRUE;
	}
}

int TextInputReader::ReadChar() {
	int iChar = pInputStream->Read();
	if (iChar == 13) {
		iLine++;
		iColumn = 0;
	}
	else if (iChar == 10) {
		iColumn = 0;
	}
	else {
		iColumn++;
	}
	return iChar;
}

BOOL TextInputReader::Error(char *pszDescription) {
	strLastError.Set(pszDescription);
	//MessageBox(NULL, pszDescription, "ERROR", MB_OK);
	return FALSE;
}

BOOL TextInputReader::ReadNextString(char cStringDelimiter) {
    strLastWord.Set("");
	int line = iLine;
	int col = iColumn;
    if (!ReadNextChar(cStringDelimiter)) {
		char cb[1024];
		wsprintf(cb, "Line %d, Column %d: Char '%c' for string expected", 
			line, col, cStringDelimiter);
		Error(cb);
		return FALSE;
	}
	else {
		while(TRUE) {
			int iChar = ReadChar();
			if (iChar == -1) {
				char cb[1024];
				wsprintf(cb, "Line %d, Column %d: Char '%c' not found for string end", 
					line, col, cStringDelimiter);
			}
			if (iChar == cStringDelimiter) {
				return TRUE;
			}
			strLastWord.Append((char) iChar);
		}
	}
}

BOOL TextInputReader::ReadWordUntilDelimiterAndSkipDelimiter(char cDelimiter) {
	int line = iLine;
	int col = iColumn;
    strLastWord.Set("");
    int iChar = ReadChar();
    if (iChar == -1)
        return FALSE;
    PushBack(iChar);
    while(TRUE) {
        iChar = ReadChar();
		if (iChar == -1)
			break;
        if ((iChar == cDelimiter) || (iChar == ' '))
            break;
        if ((iChar == 13) || (iChar == 10)) {
			PushBack(iChar);
            break;
        }
        strLastWord.Append((char) iChar);
    }

	if (strLastWord.GetLength() == 0) {
		char cb[1024];
		wsprintf(cb, "Line %d, Column %d: Word expected", line, col);
		Error(cb);
		return FALSE;
	}
	else
		return TRUE;
}
