/**
 * TextInputReader.h
 *
 * @author Matija Tomaskovic
 * @version 04-Jun-2001
 */

#if !defined(__TextInputReader_H__INCLUDED__)
#define __TextInputReader_H__INCLUDED__

#include "SuperString.h"
#include "InputStream.h"

class TextInputReader 
{
public:
	BOOL ReadWordUntilDelimiterAndSkipDelimiter(char c);
	BOOL ReadNextString(char cStringDelimiter);

    TextInputReader(InputStream* pInputStream);
    virtual ~TextInputReader();

    void SkipSpaces();

    void SkipSpacesAndEOL();
	void SkipUntilEOL();

    /**
     * @return FALSE if no more data
     */
    BOOL ReadNextWord();
    BOOL ReadNextWordInLine();
    BOOL ReadWordUntilDelimiter(char cDelimiter);

    /**
     * @return FALSE if no more data
     */
    BOOL ReadNextWord(char* pszExpectedWord);
    BOOL ReadNextWordInLine(char* pszExpectedWord);

    SuperString strLastWord;

    void PushBack(int iChar);
    void PushBack(BYTE* pBuffer, int iSize);

	BOOL Error(char* pszDescription);
	int ReadChar();
	BOOL ReadNextChar(char c);

	int iLine;
	int iColumn;

	SuperString strLastError;

private:

	InputStream* pInputStream;

};

#endif // !defined(__TextInputReader_H__INCLUDED__)
