/**
 * TextLines.cpp
 * Implementation of the TextLines class.
 *
 * @author Matija Tomaskovic
 * @version 14-Jun-2001
 */

#include "TextLines.h"
#include "FileInputStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TextLines::TextLines()
{
}

TextLines::~TextLines()
{
	Clear();
}

BOOL TextLines::LoadFromFile(char *pszFilename)
{
	FileInputStream fis;

	int iOldChar = -1;

	if (fis.Open(pszFilename)) {

		while(TRUE) {

			// Read next line
			SuperString* pString = new SuperString();
			if (iOldChar != -1) {
				pString->Append((char) iOldChar);
				iOldChar = -1;
			}

			int iChar;
			while((iChar = fis.Read()) != -1) {

				// EOL?
				if (iChar == 13) {

					// check for 10 (13 10 combination)
					iChar = fis.Read();

					if (iChar == -1) {		// EOF?
						break;
					}
					else if (iChar == 10) {	// EOL?
						break;
					}
					else {
						int iOldChar = iChar;
						break;
					}
				}

				pString->Append((char)iChar);
			}

			if (pString->GetLength() > 0)
				vLines.AddElement(pString);
			else {
				// Write all empty lines except last one..
				if (iChar != -1)
					vLines.AddElement(pString);
			}


			if (iChar == -1) {
				fis.Close();
				return TRUE;
			}
		}
	}

	return FALSE;

}

int TextLines::GetLineCount()
{
	return vLines.Size();
}

SuperString* TextLines::GetLine(int iRow)
{
	return (SuperString*) vLines.ElementAt(iRow);
}

void TextLines::AppendLine(SuperString *pSource)
{
	SuperString* pCopy = new SuperString();
	pCopy->Set(pSource->GetBuffer());
	vLines.AddElement(pCopy);
}

Buffer* TextLines::SaveToMemory()
{
	Buffer* pBuffer = new Buffer();
	for (int i=0; i<GetLineCount(); i++) {
		SuperString* p = GetLine(i);
		pBuffer->AppendString(p->GetBuffer());
		pBuffer->AppendString("\r\n");
	}
	return pBuffer;
}

void TextLines::AppendLine(char *pszText)
{
	SuperString *p = new SuperString();
	p->Set(pszText);
	AppendLine(p);
}

void TextLines::Clear() {
	for (int i=0; i<vLines.Size(); i++) {
		SuperString* p = (SuperString*) vLines.ElementAt(i);
		delete p;
	}
	vLines.Clear();
}
