/**
 * TextWriter.cpp
 * Implementation of the TextWriter class.
 *
 * @author Matija Tomaskovic
 * @version 06-Jul-2001
 */


#include "TextWriter.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TextWriter::TextWriter(OutputStream* pOutputStream) { 
	this->pOutputStream = pOutputStream;
}


TextWriter::~TextWriter() {
}


void TextWriter::WriteLine(char* pszText) {
	pOutputStream->Write((BYTE*) pszText, strlen(pszText));
	WriteEOL();
}

void TextWriter::WriteLine(SuperString *pSuperString) {
	pOutputStream->Write((BYTE*) pSuperString->GetBuffer(), pSuperString->GetLength());
	WriteEOL();
}

void TextWriter::WriteEOL() {
	pOutputStream->Write((BYTE*) "\r\n", 2);
}

void TextWriter::Write(char *pszText) {
	pOutputStream->Write((BYTE*) pszText, strlen(pszText));
}
