/**
 * Vector.cpp
 *
 * @author Matija Tomaskovic
 * @version 25-May-2001
 */

#include "Vector.h"
#include "MemoryManager.h"


Vector::Vector() {
    iMaxSize = 5;
    iSize = 0;
    ppElements = (void**) MemAlloc(sizeof(void*) * iMaxSize);
}


Vector::~Vector() {
    ppElements = NULL;
    iSize = 0;
    iMaxSize = 0;
}

void Vector::AddElement(void *pElement) {
    EnsureSize(iSize+1);
    ppElements[iSize++] = pElement;
}

void Vector::EnsureSize(int iNewSize) {
	if (iNewSize < iMaxSize)
		return;
    while (iNewSize >= iMaxSize)
        iMaxSize *= 2;
   ppElements = (void**) MemRealloc(ppElements, iMaxSize * sizeof(void*));
}

int Vector::Size() {
    return iSize;
}

void Vector::RemoveAt(int iIndex) {
    for (int i=iIndex; i<iSize-1; i++) {
        ppElements[i] = ppElements[i+1];
    }
    iSize--;
}

void Vector::RemoveElement(void* pElement) {
	BOOL hasMore = TRUE;
	while(hasMore) {
		hasMore = FALSE;
		for (int i=0; i<iSize; i++) {
			if (ppElements[i] == pElement) {
				RemoveAt(i);
				hasMore = TRUE;
				break;
			}
		}
	}
}

void* Vector::ElementAt(int iIndex) {
    return ppElements[iIndex];
}

void Vector::InsertAt(int iIndex, void* pElement) {
    EnsureSize(iSize+1);
    for (int i=iSize-1; i>iIndex; i--) {
        ppElements[i] = ppElements[i-1];
    }
    ppElements[iIndex] = pElement;
    iSize++;
}

void Vector::Clear() {
	iSize = 0;
}
