/**
 * Vector.h
 *
 * @author Matija Tomaskovic
 * @version 25-May-2001
 */

#if !defined(__VECTOR_H__INCLUDED__)
#define __VECTOR_H__INCLUDED__

#include <windows.h>

class Vector
{
public:
	void Clear();

    Vector();
    ~Vector();

    void AddElement(void* pElement);
    void* ElementAt(int iIndex);
    int Size();
    void RemoveAt(int iIndex);
	void RemoveElement(void* pElement);
    void InsertAt(int iIndex, void* pElement);

private:
    int iSize;
    void** ppElements;

    // Max. number of elements (allocated space in ppElements)
    int iMaxSize;

    void EnsureSize(int iNewSize);

};

#endif // !defined(__VECTOR_H__INCLUDED__)
