/**
 * BaseChildWindow.cpp
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#include <windows.h>
#include "BaseChildWindow.h"
#include <tomaskovic\util\Vector.h>
#include <tomaskovic\util\SuperLog.h>

char szBaseChildWindowClassName[] = "BASE_CHILD_WINDOW";
BOOL isChildClassRegistered = FALSE;

Vector vBaseChildWindows;

BaseChildWindow::BaseChildWindow() {
    hwnd = NULL;
    vBaseChildWindows.AddElement(this);
}

BaseChildWindow::~BaseChildWindow() {
    vBaseChildWindows.RemoveElement(this);
}

long FAR PASCAL BaseChildWndProc( HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam )
{
    // Find pWnd for hWnd
    BaseChildWindow* pWnd = NULL;
    for (int i=0; i<vBaseChildWindows.Size(); i++) {
        BaseChildWindow* p = (BaseChildWindow*) vBaseChildWindows.ElementAt(i);
        if (p->hwnd == hWnd) {
            pWnd = p;
			break;
		}
	}

    if ((iMsg == WM_CREATE) && (pWnd == NULL)) {
		CREATESTRUCT *pCS = (CREATESTRUCT*) lParam;
        pWnd = (BaseChildWindow*) pCS->lpCreateParams;
        pWnd->hwnd = hWnd;
	}


	if (pWnd == NULL)
		return DefWindowProc(hWnd, iMsg, wParam, lParam);
	else
        return pWnd->DoWndProc(hWnd, iMsg, wParam, lParam);
}


long BaseChildWindow::DoWndProc( HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam )
{
    switch(iMsg)
	{
        case WM_PAINT:
			OnPaint();
			return 0;

		case WM_LBUTTONDOWN: 
		{
			int fwKeys = wParam;        // key flags 
			int xPos = LOWORD(lParam);  // horizontal position of cursor 
			int yPos = HIWORD(lParam);  // vertical position of cursor 
			OnLButtonDown(xPos, yPos, fwKeys);
			return 0;
		}

		case WM_LBUTTONDBLCLK:
		{
			int fwKeys = wParam;        // key flags 
			int xPos = LOWORD(lParam);  // horizontal position of cursor 
			int yPos = HIWORD(lParam);  // vertical position of cursor 
			OnLButtonDBLCLK(xPos, yPos, fwKeys);
			return 0;
		}

		case WM_MOUSEMOVE: 
		{
			int fwKeys = wParam;        // key flags 
			int xPos = LOWORD(lParam);  // horizontal position of cursor 
			int yPos = HIWORD(lParam);  // vertical position of cursor 
			OnMouseMove(xPos, yPos, fwKeys);
			return 0;
		}

        case WM_CREATE:
			return 0;
			break;

		case WM_KEYDOWN:
		{
			int nVirtKey = (int) wParam;    // virtual-key code 
			long lKeyData = lParam;          // key data 
			OnKeyDown(nVirtKey, lKeyData);
			return 0;
		}
 

		case WM_CLOSE:
            break;

		case WM_DESTROY:
			// PostQuitMessage(0);
			break;

		case WM_KILLFOCUS:
			OnKillFocus((HWND) wParam);
			return 0;
	}

	return DefWindowProc(hWnd, iMsg, wParam, lParam);
}


BOOL BaseChildWindow::Create(HINSTANCE hInstance, HWND hwndParent,
    int x, int y, int width, int height)
{
	WNDCLASSEX  wc;

	this->hInstance = hInstance;

    if (!isChildClassRegistered) {
        wc.cbSize         = sizeof(wc);
        wc.style          = CS_HREDRAW | CS_VREDRAW;
        wc.lpfnWndProc    = BaseChildWndProc;
        wc.cbClsExtra     = 0;
        wc.cbWndExtra     = 0;
        wc.hInstance      = hInstance;
        wc.hIcon          = NULL;
        wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground  = NULL; //(HBRUSH) GetStockObject(GRAY_BRUSH);
        wc.lpszMenuName   = NULL;
        wc.lpszClassName  = szBaseChildWindowClassName;
        wc.hIconSm        = NULL; //LoadIcon(hInstance, MAKEINTRESOURCE(iIconResourceID));

        if (!RegisterClassEx(&wc)) {
            MessageBox(NULL, "Register class failed!", "ERROR", MB_OK);
            return FALSE;
        }

        isChildClassRegistered = TRUE;
    }

    hwnd = CreateWindowEx(0, szBaseChildWindowClassName, NULL,
                                WS_CHILD,	//  | WS_BORDER
								x, y, width, height,
                                hwndParent, (HMENU) 100, 
								hInstance, this);

    ShowWindow(hwnd, SW_SHOW);
    UpdateWindow(hwnd);

	return TRUE;
}



void BaseChildWindow::OnPaint() {
	PAINTSTRUCT ps;
    BeginPaint(hwnd, &ps);

	HDC hdc = ps.hdc;
	SuperLog::logLn("W3M", "BaseChildWindow::OnPaint");
	RECT rc;
	GetWindowRect(hwnd, &rc);
	int w = rc.right-rc.left;
	int h = rc.bottom-rc.top;
	MoveToEx(hdc, 0, 0, NULL);
	LineTo(hdc, w, h);
	MoveToEx(hdc, w, 0, NULL);
	LineTo(hdc, 0, h);

	EndPaint(hwnd, &ps);
}

void BaseChildWindow::OnLButtonDown(int x, int y, int flags) {
}

void BaseChildWindow::OnLButtonDBLCLK(int x, int y, int flags) {
}

void BaseChildWindow::OnMouseMove(int x, int y, int flags) {
}

void BaseChildWindow::OnKeyDown(int iVirtualKey, long lKeyData) {
}

BOOL BaseChildWindow::CreateOnPositionOf(HINSTANCE hInstance, HWND hwndParent, HWND hwndChildToCover)
{
	RECT rcWnd;
	::GetWindowRect(hwndParent, &rcWnd);
	RECT rcChild;
	::GetWindowRect(hwndChildToCover, &rcChild);

	return Create(hInstance, hwndParent, 
		rcChild.left - rcWnd.left,
		rcChild.top - rcWnd.top,
		rcChild.right - rcChild.left,
		rcChild.bottom - rcChild.top);
}


void BaseChildWindow::OnKillFocus(HWND hwndReceivingFocus) {
}

void BaseChildWindow::Invalidate() {
	InvalidateRect(hwnd, NULL, FALSE);
}
