/**
 * BaseChildWindow.h
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#if !defined(_BaseChildWindow_H__INCLUDED_)
#define _BaseChildWindow_H__INCLUDED_

#include <windows.h>


class BaseChildWindow
{

public:
	void Invalidate();
	virtual void OnKillFocus(HWND hwndReceivingFocus);
	virtual void OnKeyDown(int iVirtualKey, long lKeyData);
	BOOL CreateOnPositionOf(HINSTANCE hInstance, HWND hwndParent, HWND hwndChildToCover);
	virtual void OnMouseMove(int x, int y, int flags);
	virtual void OnLButtonDown(int x, int y, int flags);
	virtual void OnLButtonDBLCLK(int x, int y, int flags);
	virtual void OnPaint();

    BaseChildWindow();
    virtual ~BaseChildWindow();

    HWND hwnd;
	HINSTANCE hInstance;


    BOOL Create(HINSTANCE hInstance, HWND hwnd,
		int x, int y, int width, int height);

    virtual long DoWndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

};

#endif // !defined(_BaseChildWindow_H__INCLUDED_)
