/**
 * ChildPositionManager.cpp
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#include <windows.h>

#include "ChildPositionManager.h"
#include <tomaskovic\util\Array.h>


ChildPositionManager::ChildPositionManager() {
    hParent = NULL;
    hChild = NULL;
	isHorProportional = TRUE;
	isVertProportional = TRUE;
	isInitialized = FALSE;
}

ChildPositionManager::~ChildPositionManager() {
}

void ChildPositionManager::Init(HWND hParent, HWND hChild) {
    this->hParent = hParent;
    this->hChild = hChild;


}


void ChildPositionManager::SetHorProportional() {
    isHorProportional = TRUE;
}

void ChildPositionManager::SetVertProportional() {
    isVertProportional = TRUE;
}

void ChildPositionManager::SetHorAligned(BOOL isLeftAligned) {
    isHorProportional = FALSE;
    this->isLeftAligned = isLeftAligned;
}

void ChildPositionManager::SetVertAligned(BOOL isTopAligned) {
    isVertProportional = FALSE;
    this->isTopAligned = isTopAligned;
}


BOOL ChildPositionManager::Resize() {

    RECT rcChild;
    RECT rcChildClient;
    GetWindowRect(hChild, &rcChild);
    GetClientRect(hChild, &rcChildClient);

	RECT rcParent;
	RECT rcParentClient;
    GetWindowRect(hParent, &rcParent);
    GetClientRect(hParent, &rcParentClient);

    int iNewChildWidth = iChildWidth;
    int iNewChildHeight = iChildHeight;
	int iNewChildX = iChildX;
	int iNewChildY = iChildY;

    if (isHorProportional) {
        int iRightMargin = iInitParentWidth - iInitChildX - iInitChildWidth;
		iNewChildWidth = rcParentClient.right - iRightMargin - iInitChildX;
    }
	else {
		if (isLeftAligned) {
			// Dummy - no change in size or pos.
		}
		else {
	        int iRightMargin = iInitParentWidth - iInitChildX - iInitChildWidth;
			iNewChildX = rcParentClient.right - iRightMargin - iInitChildWidth;
		}
	}

    if (isVertProportional) {
        int iBottomMargin = iInitParentHeight - iInitChildY - iInitChildHeight;
		iNewChildHeight = rcParentClient.bottom - iBottomMargin - iInitChildY;
    }
	else {
		if (isTopAligned) {
			// Dummy - no change in size or pos.
		}
		else {
	        int iBottomMargin = iInitParentHeight - iInitChildY - iInitChildHeight;
			iNewChildY = rcParentClient.bottom - iBottomMargin - iInitChildHeight;
		}
	}

	BOOL isChanged = FALSE;

    if ((iNewChildX != iChildX) ||
        (iNewChildY != iChildY))
    {
        SetWindowPos(hChild,
            NULL, iNewChildX, iNewChildY, 0, 0,
            SWP_NOSIZE | SWP_NOZORDER);
		iChildX = iNewChildX;
		iChildY = iNewChildY;
        isChanged = TRUE;
    }

    if ((iNewChildWidth != (iChildWidth)) ||
        (iNewChildHeight != (iChildHeight)))
    {
        SetWindowPos(hChild,
            NULL, 0, 0,
            iNewChildWidth, iNewChildHeight,
            SWP_NOMOVE | SWP_NOZORDER);
		iChildWidth = iNewChildWidth;
		iChildHeight = iNewChildHeight;
        isChanged = TRUE;
    }

	return isChanged;
}


/**
 * @param hwndParent
 * @param hwndChild
 * @param iInitParentWidth
 * @param iInitParentHeight
 */
void ChildPositionManager::Init(
	HWND hwndParent, HWND hwndChild, 
	int iInitParentWidth, int iInitParentHeight)
{
	hParent = hwndParent;
	hChild = hwndChild;

	this->iInitParentWidth = iInitParentWidth;
	this->iInitParentHeight = iInitParentHeight;

    RECT rcChild;
    RECT rcChildClient;
    GetWindowRect(hChild, &rcChild);
    GetClientRect(hChild, &rcChildClient);

	RECT rcParent;
	RECT rcParentClient;
    GetWindowRect(hParent, &rcParent);
    GetClientRect(hParent, &rcParentClient);

	iLeftParentBorder = 0; //((rcParent.right-rcParent.left)-rcParentClient.right)/2;
	iRightParentBorder = 0; //((rcParent.right-rcParent.left)-rcParentClient.right) - iLeftParentBorder;
	iBottomParentBorder = 0; //iLeftParentBorder;
	iTopParentBorder = 0; //((rcParent.bottom-rcParent.top)-rcParentClient.bottom) - iBottomParentBorder;

	iInitChildX = rcChild.left - rcParent.left - iLeftParentBorder;
	iInitChildY = rcChild.top - rcParent.top - iTopParentBorder;
	iInitChildWidth = rcChild.right - rcChild.left;
	iInitChildHeight = rcChild.bottom - rcChild.top;

	iChildX = iInitChildX;
	iChildY = iInitChildY;
	iChildWidth = iInitChildWidth;
	iChildHeight = iInitChildHeight;

	isInitialized = TRUE;
}
