/**
 * ChildPositionManager.h
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 *
 * Usage:
 * +--------------------------------------+
 * |Parent                                |
 * |    +--------------------+            |
 * |    |Child               |            |
 * |    |                    |            |
 * |    |                    |            |
 * |    +--------------------+            |
 * |                                      |
 * |                                      |
 * +--------------------------------------+
 */

#if !defined(_ChildPositionManager_H__INCLUDED_)
#define _ChildPositionManager_H__INCLUDED_

#include <windows.h>

class ChildPositionManager
{
public:
    ChildPositionManager();
    virtual ~ChildPositionManager();

    void Init(HWND hParent, HWND hChild);

    void SetHorProportional();
    void SetVertProportional();
    void SetHorAligned(BOOL isLeftAligned);
    void SetVertAligned(BOOL isTopAligned);

    BOOL Resize();

protected:
    HWND hParent;
    HWND hChild;

    BOOL isHorProportional; // TRUE if proportional, FALSE if aligned
    BOOL isVertProportional; // TRUE if proportional, FALSE if aligned
    BOOL isLeftAligned; // TRUE if left-aligned, FALSE if right-aligned
    BOOL isTopAligned;  // TRUE if top-aligned, FALSE if bottom-aligned


public:
	/**
	 * @param hwndParent
	 * @param hwndChild
	 * @param iInitParentWidth
	 * @param iInitParentHeight
	 */
	void Init(HWND hwndParent, HWND hwndChild, int iInitParentWidth, int iInitParentHeight);

	BOOL isInitialized;

	int iInitParentWidth;
	int iInitParentHeight;
	int iInitChildX;
	int iInitChildY;
	int iInitChildWidth;
	int iInitChildHeight;

	int iChildX;
	int iChildY;
	int iChildWidth;
	int iChildHeight;

	int iLeftParentBorder;
	int iRightParentBorder;
	int iBottomParentBorder;
	int iTopParentBorder;


};

#endif // !defined(_ChildPositionManager_H__INCLUDED_)
