/**
 * XMLDocument.h
 *
 * @author Matija Tomaskovic
 * @version 11-Jul-2001
 */

#if !defined(_XMLDocument_H__INCLUDED_)
#define _XMLDocument_H__INCLUDED_

#include <windows.h>
#include <tomaskovic\util\InputStream.h>
#include <tomaskovic\util\OutputStream.h>
#include <tomaskovic\util\TextInputReader.h>
#include <tomaskovic\util\Vector.h>
#include <tomaskovic\xml\XMLElement.h>

class XMLElement;

class XMLDocument
{
public:
	XMLElement* GetElement(char* pszPath);
    XMLDocument();
    ~XMLDocument();

	BOOL Error(TextInputReader* pTextInputReader);
	BOOL Error(char* pszDescription);

	BOOL Load(InputStream* pInputStream);

	SuperString strLastError;
	XMLElement* pRootElement;

	BOOL GetValue(SuperString *pstrValueDest, char *pszPath);

	int GetCount(char* pszPath);

	XMLElement* LoadElement(TextInputReader *pTextInputReader);
	void Save(OutputStream *pOutputStream);

private:
	void SaveElement(OutputStream *pOutputStream, int iTabs, XMLElement *pElement);

};

#endif // !defined(_XMLDocument_H__INCLUDED_)
