/**
 * XMLElement.cpp
 *
 * @author Matija Tomaskovic
 * @version 11-Jul-2001
 */
#include "XMLElement.h"
#include "XMLAttribute.h"


XMLElement::XMLElement(char* pszName) {
	strName.Set(pszName);
}


XMLElement::~XMLElement() {
	// Delete attributes
	for (int i=0; i<vAttributes.Size(); i++) {
		XMLAttribute* pXMLAttribute = 
			(XMLAttribute*) vAttributes.ElementAt(i);
		delete pXMLAttribute;
	}
}


void XMLElement::AddAttribute(char *pszName, char *pszValue) {
	XMLAttribute* pXMLAttribute = new XMLAttribute();
	pXMLAttribute->strName.Set(pszName);
	pXMLAttribute->strValue.Set(pszValue);
	vAttributes.AddElement(pXMLAttribute);
}

void XMLElement::AddChildElement(XMLElement *pChildElement) {
	vChildElements.AddElement(pChildElement);
}

XMLAttribute* XMLElement::GetAttribute(char *pszName) {
	for (int i=0; i<vAttributes.Size(); i++) {
		XMLAttribute* pAttribute = 
			(XMLAttribute*) vAttributes.ElementAt(i);
		if (pAttribute->strName.Equals(pszName))
			return pAttribute;
	}
	return NULL;
}

XMLElement* XMLElement::AddChildElement(char *pszName)
{
	XMLElement* pElement = new XMLElement(pszName);
	AddChildElement(pElement);
	return pElement;
}

void XMLElement::AddAttribute(char *pszName, int iValue) {
	SuperString s;
	s.AppendInt(iValue);
	AddAttribute(pszName, s.GetBuffer());
}

void XMLElement::AddAttribute(char *pszName, float fValue, int iDecimals) {
	SuperString s;
	s.AppendFloat(fValue, iDecimals);
	AddAttribute(pszName, s.GetBuffer());
}

BOOL XMLElement::GetValue(SuperString *pstrValueDest, char *pszPath) {
	XMLElement* pElement = GetElement(pszPath);
	if (pElement) {
		SuperString strPath(pszPath);
		int iVar = strPath.IndexOf('@');
		// if no @ attribute name - return element value
		if (iVar == -1) {
			pstrValueDest->Set(strValue.GetBuffer());
			return TRUE;
		}
		else {
			strPath.Substring(iVar+1, strPath.GetLength()-iVar-1);
			// Find attribute
			XMLAttribute* pAttribute = pElement->GetAttribute(strPath.GetBuffer());
			if (pAttribute) {
    			pstrValueDest->Set(pAttribute->strValue.GetBuffer());
				return TRUE;
			}
			else {
	    		// Did not find attribute
				return FALSE;
			}
		}
	}
	else {
		return FALSE;
	}
}



int XMLElement::GetCount(char *pszPath) {
	SuperString strPath(pszPath);

	// If only element name ("ad"), return number of childs with this name
	int iSlash = strPath.IndexOf('.');
	if (iSlash == -1) {
	    int iCount = 0;
	    for (int i = 0; i < vChildElements.Size(); i++) {
			XMLElement *pChild = (XMLElement*) vChildElements.ElementAt(i);
			if (pChild->strName.Equals(strPath.GetBuffer())) {
	        	iCount++;
			}
		}
	    return iCount;
	}


    int iPathPos = 0;
    int iPathLen = strPath.GetLength();

    //
    // Scan path to extract (first) node name
    //

    SuperString strName;
    BOOL bHasDigits = FALSE;
    while(iPathPos < iPathLen) {
    	char c = strPath.CharAt(iPathPos++);
    	if ((c == '.') || (c == '@')) {
            iPathPos--;
    		break;
    	}
    	else if (c != '<') {
    		// append character
            strName.Append(c);
    	}
    	else {	// c == '<'
    		bHasDigits = TRUE;
    		break;
    	}
    }

    int iWantedNo = 1;

    //
    // If has digits - scan for number, otherwise leave 1 (default)
    //

    if (bHasDigits) {
    	// Scan for wanted node No
        SuperString strNum;
    	int iDigits = 0;
    	BOOL bEndFound = FALSE;
    	// scan for num digits
    	while((iPathPos < iPathLen) && (iDigits < 10)) {
    		char c = strPath.CharAt(iPathPos++);
    		// if not end of digits
    		if (c != '>') {
    			strNum.Append(c);
    		}
    		else {	// c == '>'
    			bEndFound = TRUE;
    			break;
    		}
    	}

    	// If no end - error
    	if (!bEndFound)
    		return 0;

    	iWantedNo = strNum.IntValue();

    	// If failed to convert
    	if (iWantedNo == -1)
    		return 0;
    }

    //
    // Now we have element name strName and No of wanted element to count..
    //

    int iCurrentNo = 0;
    BOOL isWantedElementFound = FALSE;
    XMLElement* pWantedElement = NULL;
    // Try to find wanted element...
    for (int i = 0; i < vChildElements.Size(); i++) {
		XMLElement *pChild = (XMLElement*) vChildElements.ElementAt(i);
    	if (pChild->strName.Equals(strName.GetBuffer())) {
    		iCurrentNo++;
    		if (iCurrentNo == iWantedNo) {
    			isWantedElementFound = TRUE;
    			pWantedElement = pChild;
    			break;
    		}
    	}
    }

    // if no node - then there is 0 of them
    if (!isWantedElementFound)
    	return 0;

    //
    // Now we have wanted node
    //

    // another element... scan in depth
	iPathPos++;	// skip '.'
	SuperString strPathCopy(strPath.GetBuffer());
	strPathCopy.Substring(iPathPos, strPathCopy.GetLength()-iPathPos);
	return pWantedElement->GetCount(strPathCopy.GetBuffer());
}


XMLElement* XMLElement::GetElement(char *pszPath) {
	// "@name" - return this and ignore "@name"
    // "ad" get child "ad"
    // "ads<1>.ad<1>" 
    // "ads<1>.ad"
    // "ads<1>.ad<1>@name"  - ignores "@name"

	SuperString strPath(pszPath);

    int iPathPos = 0;
    int iPathLen = strPath.GetLength();

	if (strPath.CharAt(0) == '@')
		return this;

    //
    // Scan path to extract (first) element name
    //

    SuperString strName;
    BOOL bHasDigits = false;
    while(iPathPos < iPathLen) {
    	char c = strPath.CharAt(iPathPos++);
    	if ((c == '.') || (c == '@')) {
            iPathPos--;
    		break;
    	}
    	else if (c == '<') {
    		bHasDigits = TRUE;
    		break;
    	}
    	else { // c != '<'
            strName.Append(c);
    	}
    }

    int iWantedNo = 1;

    //
    // If has digits - scan for number, otherwise leave 1 (default)
    //

    if (bHasDigits) {
    	// Scan for wanted node No
        SuperString strNum;
    	int iDigits = 0;
    	BOOL bEndFound = FALSE;
    	// scan for num digits
    	while((iPathPos < iPathLen) && (iDigits < 10)) {
    		char c = strPath.CharAt(iPathPos++);
    		// if not end of digits
    		if (c != '>') {
    			strNum.Append(c);
    		}
    		else {	// c == '>'
    			bEndFound = TRUE;
    			break;
    		}
    	}

    	// If no end - error
    	if (!bEndFound) {
    		return FALSE;
        }

    	iWantedNo = strNum.IntValue();

    	// If failed to convert
    	if (iWantedNo == -1)
    		return FALSE;
    }

    //
    // Now we have element name strName and No of wanted element
    //

	int iCurrentNo = 0;
	BOOL isWantedElementFound = FALSE;
	XMLElement* pWantedElement = NULL;
    // Try to find wanted element...
    for (int i=0; i<vChildElements.Size(); i++) {
		XMLElement *pChild = (XMLElement*) vChildElements.ElementAt(i);
    	if (pChild->strName.Equals(strName.GetBuffer())) {
    		iCurrentNo++;
    		if (iCurrentNo == iWantedNo) {
    			isWantedElementFound = TRUE;
    			pWantedElement = pChild;
    			break;
    		}
    	}
    }

    if (!isWantedElementFound)
    	return FALSE;

    //
    // Now we have wanted node
    //

    // if there was onyl e.g. "ad<1>" - we are at the end..
    if (iPathPos == iPathLen) {
		return pWantedElement;
    }
    else {
    	// check if attribute.. e.g. "ad<1>@height"
    	char c = strPath.CharAt(iPathPos);
    	if (c == '@') {
			return pWantedElement;
    	}
    	// another element... scan in depth
    	else {
    		iPathPos++;	// skip '.'
			SuperString strNewPath(strPath.GetBuffer());
			strNewPath.Substring(iPathPos, strNewPath.GetLength() - iPathPos);
    		return pWantedElement->GetElement(strNewPath.GetBuffer());
    	}
    }
}
