/**
 * XMLElement.h
 *
 * @author Matija Tomaskovic
 * @version 11-Jul-2001
 */

#if !defined(_XMLElement_H__INCLUDED_)
#define _XMLElement_H__INCLUDED_

#include <windows.h>
#include <tomaskovic\util\SuperString.h>
#include <tomaskovic\util\Vector.h>

class XMLDocument;
class XMLAttribute;

class XMLElement
{
public:
    XMLElement(char* pszName);
    ~XMLElement();

	XMLElement* AddChildElement(char* pszName);
	void AddChildElement(XMLElement *pChildElement);

	void AddAttribute(char* pszName, char* pszValue);
	void AddAttribute(char* pszName, float fValue, int iDecimals);
	void AddAttribute(char* pszName, int iValue);

	Vector vChildElements;
	Vector vAttributes;
	SuperString strName;
	SuperString strValue;

	XMLAttribute* GetAttribute(char* pszName);

	BOOL GetValue(SuperString *pstrValueDest, char *pszPath);
	XMLElement* GetElement(char *pszPath);

	int GetCount(char *pszPath);

};

#endif // !defined(_XMLElement_H__INCLUDED_)
