/*
 * Decompiled with CFR 0.152.
 */
package com.tomaskovic.util.sql;

import com.tomaskovic.util.sql.SQLExecutor;
import com.tomaskovic.util.swingui.SingleTableRowListSelectionListener;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SQLTableManager {
    JTable jTable;
    ResultSetTableModel tm;
    SingleTableRowListSelectionListener lsl;
    String strQuery;
    Connection connection;
    int iPosition;
    int iMaxRows = 20;
    SQLExecutor sqlExecutor;

    public SQLTableManager(SQLExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
        this.tm = new ResultSetTableModel();
    }

    public void attachTo(JTable jTable) {
        this.jTable = jTable;
        jTable.setModel(this.tm);
        this.lsl = new SingleTableRowListSelectionListener(jTable);
    }

    public void setQuery(String strQuery, Connection connection) {
        this.strQuery = strQuery;
        this.connection = connection;
        this.firstPage();
    }

    public void firstPage() {
        this.iPosition = 1;
        this.refresh();
    }

    public void nextPage() {
        this.iPosition += this.iMaxRows;
        this.refresh();
    }

    public void prevPage() {
        this.iPosition -= this.iMaxRows;
        if (this.iPosition < 1) {
            this.iPosition = 1;
        }
        this.refresh();
    }

    public Object[] getSelectedRow() {
        int iRow;
        if (this.lsl != null && (iRow = this.lsl.iSelectedRow) != -1) {
            return (Object[])this.tm.vRows.elementAt(iRow);
        }
        return null;
    }

    public int[] getColumnTypes() {
        if (this.tm != null) {
            return this.tm.iColumnTypes;
        }
        return null;
    }

    public String[] getColumnNames() {
        if (this.tm != null) {
            return this.tm.strColumnNames;
        }
        return null;
    }

    public int[] getColumnDisplaySizes() {
        if (this.tm != null) {
            return this.tm.iColumnSizes;
        }
        return null;
    }

    protected void refresh() {
        if (this.connection == null) {
            return;
        }
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultset = statement.executeQuery(this.strQuery);
            this.tm.fill(resultset, this.iPosition, this.iMaxRows);
            statement.close();
        }
        catch (SQLException se) {
            this.sqlExecutor.showSQLException(this.strQuery, se);
            this.tm.clear();
        }
    }

    public void adjustColumnSizes() {
        if (this.tm != null) {
            this.tm.adjustColumnSizes();
            this.jTable.revalidate();
            this.jTable.repaint();
            this.jTable.getTableHeader().resizeAndRepaint();
        }
    }

    public void setRowsToFetch(int iRowsToFetch) {
        this.iMaxRows = iRowsToFetch;
    }

    public void setSmallerColumns() {
        if (this.tm != null) {
            if (this.jTable != null && this.tm.iColumnCount > 0) {
                for (int i = 0; i < this.tm.iColumnCount; ++i) {
                    TableColumn column;
                    TableColumnModel tcm = this.jTable.getColumnModel();
                    if (tcm == null || (column = tcm.getColumn(i)) == null) continue;
                    int iWidth = column.getWidth();
                    if (iWidth > 30) {
                        iWidth -= 10;
                    }
                    column.setPreferredWidth(iWidth);
                    column.setWidth(iWidth);
                }
            }
            this.jTable.revalidate();
            this.jTable.repaint();
            this.jTable.getTableHeader().resizeAndRepaint();
        }
    }

    public void setBiggerColumns() {
        if (this.tm != null) {
            if (this.jTable != null && this.tm.iColumnCount > 0) {
                for (int i = 0; i < this.tm.iColumnCount; ++i) {
                    TableColumn column;
                    TableColumnModel tcm = this.jTable.getColumnModel();
                    if (tcm == null || (column = tcm.getColumn(i)) == null) continue;
                    int iWidth = column.getWidth();
                    column.setPreferredWidth(iWidth += 10);
                    column.setWidth(iWidth);
                }
            }
            this.jTable.revalidate();
            this.jTable.repaint();
            this.jTable.getTableHeader().resizeAndRepaint();
        }
    }

    class ResultSetTableModel
    extends AbstractTableModel {
        int iColumnCount = 0;
        String[] strColumnNames;
        int[] iColumnDisplaySizes;
        int[] iColumnSizes;
        int[] iColumnTypes;
        Vector vRows = null;

        public int getColumnCount() {
            return this.iColumnCount;
        }

        public int getRowCount() {
            if (this.vRows == null) {
                return 0;
            }
            return this.vRows.size();
        }

        public String getColumnName(int col) {
            return this.strColumnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (this.vRows == null) {
                return "";
            }
            Object[] oRow = (Object[])this.vRows.elementAt(row);
            if (oRow == null) {
                return "null";
            }
            Object o = oRow[col];
            if (o == null) {
                return "null";
            }
            int iType = this.iColumnTypes[col];
            if (iType == 2 || iType == 4) {
                return "".concat(String.valueOf(String.valueOf(o)));
            }
            if (iType == 1 || iType == 12) {
                return String.valueOf(String.valueOf(new StringBuffer("'").append(o).append("'")));
            }
            if (iType == 93) {
                Date d = (Date)o;
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(d);
                return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(c.get(5)))).append(".").append(c.get(2) + 1).append(".").append(c.get(1)).append(" ").append(c.get(10)).append(":").append(c.get(12)).append(":").append(c.get(13))));
            }
            return String.valueOf(String.valueOf(new StringBuffer("'").append(o).append("'")));
        }

        public void clear() {
            this.iColumnCount = 0;
            this.fireTableStructureChanged();
        }

        public Class getColumnClass(int c) {
            return "".getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
            this.fireTableCellUpdated(row, col);
        }

        public void fill(ResultSet resultset, int iStart, int iCount) {
            try {
                this.iColumnCount = 0;
                this.fireTableStructureChanged();
                SQLTableManager.this.jTable.revalidate();
                SQLTableManager.this.jTable.repaint();
                boolean bSizeColumnToLabel = false;
                ResultSetMetaData m = resultset.getMetaData();
                this.iColumnCount = m.getColumnCount();
                this.iColumnSizes = new int[this.iColumnCount];
                this.strColumnNames = new String[this.iColumnCount];
                this.iColumnTypes = new int[this.iColumnCount];
                this.iColumnDisplaySizes = new int[this.iColumnCount];
                for (int i = 1; i < this.iColumnCount + 1; ++i) {
                    this.iColumnDisplaySizes[i - 1] = m.getColumnDisplaySize(i);
                    this.strColumnNames[i - 1] = m.getColumnLabel(i);
                    this.iColumnTypes[i - 1] = m.getColumnType(i);
                    int iSize = m.getColumnLabel(i).length();
                    if (m.getColumnDisplaySize(i) > iSize) {
                        iSize = m.getColumnDisplaySize(i);
                    }
                    if (iSize > 50) {
                        iSize = 50;
                    }
                    this.iColumnSizes[i - 1] = iSize;
                }
                this.vRows = new Vector();
                int iRow = 0;
                while (resultset.next()) {
                    if (++iRow < SQLTableManager.this.iPosition) continue;
                    if (iRow > SQLTableManager.this.iPosition + SQLTableManager.this.iMaxRows) break;
                    Object[] o = this.cacheRow(resultset);
                    this.vRows.add(o);
                }
                this.fireTableStructureChanged();
            }
            catch (SQLException se) {
                se.printStackTrace();
                return;
            }
        }

        private void adjustColumnSizes() {
            if (SQLTableManager.this.jTable != null && this.iColumnCount > 0) {
                TableColumn column = null;
                for (int i = 0; i < this.iColumnCount; ++i) {
                    TableColumnModel tcm = SQLTableManager.this.jTable.getColumnModel();
                    if (tcm == null || (column = tcm.getColumn(i)) == null) continue;
                    column.setPreferredWidth(this.iColumnSizes[i] * 5);
                    column.setWidth(this.iColumnSizes[i] * 5);
                }
            }
        }

        private Object[] cacheRow(ResultSet resultset) {
            try {
                Object[] row = new Object[this.iColumnCount];
                for (int i = 1; i < this.iColumnCount + 1; ++i) {
                    int iType = this.iColumnTypes[i - 1];
                    if (iType == 2 || iType == 4) {
                        if (resultset.getString(i) == null) {
                            row[i - 1] = null;
                            continue;
                        }
                        row[i - 1] = new Integer(resultset.getInt(i));
                        continue;
                    }
                    row[i - 1] = iType == 1 || iType == 12 ? resultset.getString(i) : (iType == 93 ? resultset.getDate(i) : resultset.getString(i));
                }
                Object[] objectArray = row;
                return objectArray;
            }
            catch (SQLException se) {
                se.printStackTrace();
                Object[] objectArray = null;
                return objectArray;
            }
        }
    }
}

