/*
 * Decompiled with CFR 0.152.
 */
package com.tomaskovic.tjad;

import com.tomaskovic.tjad.ConnectionEntry;
import com.tomaskovic.tjad.DatabaseParamsDlg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class ConnectionListDlg
extends JDialog {
    String strResult = "Cancel";
    int[] iTableColumnWidths = new int[]{245, 75, 75, 190};
    JScrollPane jScrollPane1 = new JScrollPane();
    MyTableModel tm = new MyTableModel();
    JTable jTable1 = new JTable(this.tm);
    SingleTableRowListSelectionListener lsl;
    JButton jButtonNew = new JButton();
    JButton jButtonEdit = new JButton();
    JButton jButtonDelete = new JButton();
    JButton jButtonSelect = new JButton();
    JButton jButtonCancel = new JButton();
    Frame frame;

    public ConnectionListDlg(Frame frame, String title, boolean modal, Vector vConnectionEntries) {
        super(frame, title, modal);
        this.frame = frame;
        this.tm.vdata = vConnectionEntries;
        try {
            this.jbInit();
            this.pack();
            int iWidth = 624;
            int iHeight = 400;
            Dimension d = this.getToolkit().getScreenSize();
            ((Component)this).setBounds((d.width - iWidth) / 2, (d.height - iHeight) / 2, iWidth, iHeight);
            this.jTable1.setAutoResizeMode(0);
            TableColumn column = null;
            for (int i = 0; i < this.iTableColumnWidths.length; ++i) {
                column = this.jTable1.getColumnModel().getColumn(i);
                column.setPreferredWidth(this.iTableColumnWidths[i]);
            }
            this.lsl = new SingleTableRowListSelectionListener(this, this.jTable1);
            this.updateDisplay();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.jScrollPane1.setBounds(new Rectangle(13, 12, 593, 311));
        this.jButtonNew.setMnemonic('N');
        this.jButtonNew.setText("New...");
        this.jButtonNew.setBounds(new Rectangle(13, 333, 81, 27));
        this.jButtonNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionListDlg.this.jButtonNew_actionPerformed(e);
            }
        });
        this.jButtonEdit.setMnemonic('E');
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.setBounds(new Rectangle(104, 333, 81, 27));
        this.jButtonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionListDlg.this.jButtonEdit_actionPerformed(e);
            }
        });
        this.jButtonDelete.setMnemonic('D');
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setBounds(new Rectangle(196, 333, 81, 27));
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionListDlg.this.jButtonDelete_actionPerformed(e);
            }
        });
        this.jButtonSelect.setMnemonic('S');
        this.jButtonSelect.setText("Select");
        this.jButtonSelect.setBounds(new Rectangle(432, 333, 81, 27));
        this.jButtonSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionListDlg.this.jButtonSelect_actionPerformed(e);
            }
        });
        this.jButtonCancel.setMnemonic('C');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setBounds(new Rectangle(525, 333, 81, 27));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionListDlg.this.jButtonCancel_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jScrollPane1, null);
        this.getContentPane().add((Component)this.jButtonNew, null);
        this.getContentPane().add((Component)this.jButtonEdit, null);
        this.getContentPane().add((Component)this.jButtonDelete, null);
        this.getContentPane().add((Component)this.jButtonCancel, null);
        this.getContentPane().add((Component)this.jButtonSelect, null);
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.strResult = "Cancel";
        this.dispose();
    }

    void jButtonSelect_actionPerformed(ActionEvent e) {
        this.strResult = "Select";
        this.dispose();
    }

    void jButtonDelete_actionPerformed(ActionEvent e) {
        this.tm.deleteSelectedRow();
    }

    void jButtonEdit_actionPerformed(ActionEvent e) {
        ConnectionEntry ee = this.tm.getSelectedEntry();
        DatabaseParamsDlg dlg = new DatabaseParamsDlg(this.frame, "Edit database connection", true);
        dlg.setJDBCDriver(ee.strJdbcDriver);
        dlg.jTextFieldUser.setText(ee.strUser);
        ((JTextComponent)dlg.jPasswordFieldPassword).setText(ee.strPassword);
        dlg.setJDBCURL(ee.strJdbcUrl);
        dlg.show();
        if (dlg.strResult.equals("OK")) {
            ee.strJdbcDriver = dlg.getJDBCDriver();
            ee.strUser = dlg.jTextFieldUser.getText();
            ee.strPassword = new String(dlg.jPasswordFieldPassword.getPassword());
            ee.strJdbcUrl = dlg.getJDBCURL();
            this.tm.fireTableDataChanged();
        }
    }

    void jButtonNew_actionPerformed(ActionEvent e) {
        DatabaseParamsDlg dlg = new DatabaseParamsDlg(this.frame, "New database connection", true);
        dlg.show();
        if (dlg.strResult.equals("OK")) {
            String strJdbcDriver = dlg.getJDBCDriver();
            String strUser = dlg.jTextFieldUser.getText();
            String strPassword = new String(dlg.jPasswordFieldPassword.getPassword());
            String strJdbcUrl = dlg.getJDBCURL();
            ConnectionEntry ce = new ConnectionEntry(strJdbcUrl, strUser, strPassword, strJdbcDriver);
            this.tm.addRow(ce);
        }
    }

    private void updateDisplay() {
        int rows = this.tm.getRowCount();
        if (rows == 0) {
            this.jButtonDelete.setEnabled(false);
            this.jButtonEdit.setEnabled(false);
            this.jButtonSelect.setEnabled(false);
        } else {
            this.jButtonDelete.setEnabled(true);
            this.jButtonEdit.setEnabled(true);
            this.jButtonSelect.setEnabled(true);
        }
    }

    class SingleTableRowListSelectionListener
    implements ListSelectionListener {
        int iSelectedRow = -1;

        public SingleTableRowListSelectionListener(ConnectionListDlg this$0, JTable table) {
            table.setSelectionMode(0);
            ListSelectionModel rowSM = table.getSelectionModel();
            rowSM.addListSelectionListener(this);
            table.setRowSelectionInterval(0, 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            int selectedRow;
            if (e.getValueIsAdjusting()) {
                this.iSelectedRow = -1;
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            this.iSelectedRow = lsm.isSelectionEmpty() ? -1 : (selectedRow = lsm.getMinSelectionIndex());
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"JDBC URL", "Username", "Password", "JDBC Driver"};
        Vector vdata = new Vector();

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.vdata.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            ConnectionEntry e = (ConnectionEntry)this.vdata.get(row);
            if (col == 0) {
                return e.strJdbcUrl;
            }
            if (col == 1) {
                return e.strUser;
            }
            if (col == 2) {
                return "********";
            }
            if (col == 3) {
                return e.strJdbcDriver;
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
            this.fireTableCellUpdated(row, col);
        }

        private void deleteSelectedRow() {
            if (ConnectionListDlg.this.lsl.iSelectedRow != -1 && ConnectionListDlg.this.lsl.iSelectedRow + 1 <= this.vdata.size()) {
                this.vdata.remove(ConnectionListDlg.this.lsl.iSelectedRow);
                this.fireTableChanged(new TableModelEvent(this));
                ConnectionListDlg.this.jTable1.setRowSelectionInterval(0, 0);
                ConnectionListDlg.this.updateDisplay();
            }
        }

        public void addRow(ConnectionEntry e) {
            this.vdata.add(e);
            this.fireTableDataChanged();
            ConnectionListDlg.this.updateDisplay();
        }

        public ConnectionEntry getSelectedEntry() {
            if (ConnectionListDlg.this.lsl.iSelectedRow != -1) {
                return (ConnectionEntry)this.vdata.get(ConnectionListDlg.this.lsl.iSelectedRow);
            }
            return null;
        }
    }
}

