/*
 * Decompiled with CFR 0.152.
 */
package com.tomaskovic.tjad;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import javax.swing.JEditorPane;

public class SQLEditor {
    JEditorPane jEditor;
    private LineNumberReader lnReader;

    public SQLEditor(JEditorPane jEditor) {
        this.jEditor = jEditor;
    }

    public String getCurrentCommand() {
        String strAllText = this.jEditor.getText();
        int iCaretPosition = this.jEditor.getCaretPosition();
        String str = this.getCommandAtPosition(strAllText, iCaretPosition);
        str = str.trim();
        str = SQLEditor.removeTrailingSemicolonFromSQL(str);
        return str;
    }

    private String getCommandAtPosition(String strText, int iPosition) {
        if (strText == null) {
            return "";
        }
        try {
            int iEnd;
            int iStart;
            int iLength = strText.length();
            if (iLength == 0) {
                String string = "";
                return string;
            }
            while (iPosition > 0 && strText.charAt(iPosition - 1) != '\n') {
                --iPosition;
            }
            for (iStart = iPosition; iStart != 0 && (iStart != 1 || strText.charAt(iStart - 1) != '\n'); --iStart) {
                int ii;
                if (iStart <= 2 || strText.charAt(iStart - 1) != '\n') continue;
                for (ii = iStart - 2; ii > 0 && strText.charAt(ii) != '\n' && strText.charAt(ii) == ' '; --ii) {
                }
                if (ii == 0 || strText.charAt(ii) == '\n') break;
            }
            for (iEnd = iPosition; iEnd != iLength; ++iEnd) {
                int ii;
                if (iEnd >= iLength - 2) continue;
                if (strText.charAt(iEnd) == ';') {
                    for (ii = iEnd + 1; ii < iLength && strText.charAt(ii) != '\n' && strText.charAt(ii) == ' '; ++ii) {
                    }
                }
                if (strText.charAt(iEnd) != '\n') continue;
                for (ii = iEnd + 1; ii < iLength && strText.charAt(ii) != '\n' && strText.charAt(ii) == ' '; ++ii) {
                }
                if (ii == iLength || strText.charAt(ii) == '\n') break;
            }
            if (iStart >= iEnd) {
                String ii = "";
                return ii;
            }
            String sql = strText.substring(iStart, iEnd);
            sql = sql.trim();
            String string = sql = SQLEditor.removeTrailingSemicolonFromSQL(sql);
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
    }

    public String getFirstCommand() {
        String strAllText = this.jEditor.getText();
        StringReader sr = new StringReader(strAllText);
        return this.getFirstCommand(sr);
    }

    public String getFirstCommand(StringReader srSQLScript) {
        this.lnReader = new LineNumberReader(srSQLScript);
        return this.getNextCommand();
    }

    public String getNextCommand() {
        String strSQL = "";
        try {
            String strLine = this.lnReader.readLine();
            while (strLine != null && strLine.trim().equals("")) {
                strLine = this.lnReader.readLine();
            }
            if (strLine == null) {
                this.lnReader.close();
                String string = "";
                return string;
            }
            strSQL = strLine;
            strLine = this.lnReader.readLine();
            while (strLine != null && !strLine.trim().equals("")) {
                strSQL = String.valueOf(String.valueOf(strSQL)).concat(String.valueOf(String.valueOf(strLine)));
                if (strLine.trim().endsWith(";")) break;
                strLine = this.lnReader.readLine();
            }
            strSQL = strSQL.trim();
            String string = SQLEditor.removeTrailingSemicolonFromSQL(strSQL);
            return string;
        }
        catch (IOException e) {
            try {
                this.lnReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string = "";
            return string;
        }
    }

    public static String removeTrailingSemicolonFromSQL(String sql) {
        if ((sql = sql.trim()).length() > 1 && sql.substring(sql.length() - 1, sql.length()).equals(";")) {
            return sql.substring(0, sql.length() - 1);
        }
        return sql;
    }
}

