/*
 * Decompiled with CFR 0.152.
 */
package com.tomaskovic.tjad;

import com.tomaskovic.tjad.ConnectionEntry;
import com.tomaskovic.tjad.ConnectionListDlg;
import com.tomaskovic.tjad.DatabaseParamsDlg;
import com.tomaskovic.tjad.ExportTableDlg;
import com.tomaskovic.tjad.SQLEditor;
import com.tomaskovic.tjad.TjadOptionsDlg;
import com.tomaskovic.util.file.Path;
import com.tomaskovic.util.sql.SQLExecutor;
import com.tomaskovic.util.sql.SQLScript;
import com.tomaskovic.util.sql.SQLTableManager;
import com.tomaskovic.util.sql.SQLTableManagerPanel;
import com.tomaskovic.util.swingui.MessageDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class TJADFrame
extends JFrame
implements SQLExecutor {
    public static String strAPP_NAME = "TJAD";
    public static String strAPP_VERSION = "v1.36";
    public static String strAPP_RELEASE_DATE = "17-Oct-2001";
    public static String strAPP_COPYRIGHT = "(C) by Matija Tomaskovic";
    public static final String strRESULT_SEPARATOR = "\n-----------------------------------------------------------------------\n";
    static final int TAB_TEXTAREA = 0;
    static final int TAB_GRID = 1;
    String strAPP_TITLE = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strAPP_NAME))).append(" ").append(strAPP_VERSION)));
    String strAppPath;
    SQLEditor sqlEditor;
    SQLTableManager sqlTableManager;
    public boolean bSizeColumnToLabel = false;
    public boolean bAutoCommit = true;
    public boolean bShowExceptionStackTrace = false;
    public boolean bShowException = true;
    public boolean bAutoSwitchToGrid = true;
    int iRowsToFetch = 20;
    boolean bLimitRowsToFetch = true;
    int iInitialTab = 0;
    int iDividerLocation = 100;
    ConnectionEntry lastConnectionEntry;
    String strLastPath = ".";
    Connection connection;
    Statement statement;
    Hashtable htDrivers = new Hashtable();
    JMenuBar jMainMenuBar = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMainMenuItemFileExit = new JMenuItem();
    JMenu jMenuEdit = new JMenu();
    JSplitPane jSplitPaneMain = new JSplitPane();
    JScrollPane jScrollPaneEdit = new JScrollPane();
    JEditorPane jEditor = new JEditorPane();
    JMenu jMenuDatabase = new JMenu();
    JMenuItem jMenuItemDatabaseConnect = new JMenuItem();
    JMenuItem jMenuItemDatabaseDisconnect = new JMenuItem();
    JMenuItem jMenuItemDatabaseExecuteQuery = new JMenuItem();
    JMenuItem jMenuItemDatabaseExecuteUpdate = new JMenuItem();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenuItem jMenuItem3 = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuItemHelpAbout = new JMenuItem();
    JMenu jMenu1 = new JMenu();
    JCheckBoxMenuItem jCheckBoxMenuItemViewSizeColumnToLabel = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuItemDatabaseAutoCommit = new JCheckBoxMenuItem();
    JMenuItem jMenuItemDatabaseConnectViaList = new JMenuItem();
    Vector vConnectionEntries = new Vector();
    String strConfigFilename;
    JMenuItem jMenuItemDatabaseExecuteQueryOrUpdate = new JMenuItem();
    JMenuItem jMenuItemDatabaseExecuteWindow = new JMenuItem();
    JMenuItem jMenuItemFileNew = new JMenuItem();
    JMenuItem jMenuItemFileOpen = new JMenuItem();
    JMenuItem jMenuItemSaveAs = new JMenuItem();
    JMenuItem jMenuItemDatabaseSaveCurrentConnection = new JMenuItem();
    JMenuItem jMenuItemDatabaseDataExport = new JMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuItemViewShowStackTrace = new JCheckBoxMenuItem();
    JMenuItem jMenuItemFileExecuteScript = new JMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuItemViewShowException = new JCheckBoxMenuItem();
    JMenu jMenu2 = new JMenu();
    JMenuItem jMenuItemToolsOptions = new JMenuItem();
    JMenuItem jMenuItem4 = new JMenuItem();
    JTabbedPane jTabbedPaneResult = new JTabbedPane();
    JScrollPane jScrollPaneTextResult = new JScrollPane();
    JTextArea jTextAreaResult = new JTextArea();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelResult = new JPanel();
    JScrollPane jScrollPaneTable = new JScrollPane();
    JTable jTableResult = new JTable();
    SQLTableManagerPanel jSQLTableManagerPanel;
    BorderLayout borderLayout2 = new BorderLayout();
    JCheckBoxMenuItem jCheckBoxMenuItemAutoSwitchToGrid = new JCheckBoxMenuItem();

    public TJADFrame(String strAppPath) {
        this.strAppPath = strAppPath;
        this.strConfigFilename = new File(Path.mergePathAndName(strAppPath, "tjad.prop")).getAbsolutePath();
        try {
            this.sqlTableManager = new SQLTableManager(this);
            this.jSQLTableManagerPanel = new SQLTableManagerPanel(this, this.sqlTableManager, this);
            this.jbInit();
            Dimension d = this.getToolkit().getScreenSize();
            int iWidth = d.width * 3 / 4;
            int iHeight = d.height * 3 / 4;
            ((Component)this).setBounds((d.width - iWidth) / 2, (d.height - iHeight) / 2, iWidth, iHeight);
            this.setTitle(this.strAPP_TITLE);
            this.sqlEditor = new SQLEditor(this.jEditor);
            this.jTableResult.setAutoResizeMode(0);
            this.sqlTableManager.attachTo(this.jTableResult);
            this.loadConfigFile();
            this.jTabbedPaneResult.setSelectedIndex(this.iInitialTab);
            this.jSplitPaneMain.setDividerLocation(100);
            this.sqlTableManager.setRowsToFetch(this.iRowsToFetch);
            this.updateDisplay();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ((Frame)this).setIconImage(new ImageIcon("images/icon.gif").getImage());
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().setBackground(Color.pink);
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.jMainMenuBar);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TJADFrame.this.this_keyPressed(e);
            }
        });
        this.jMenuFile.setMnemonic('F');
        this.jMenuFile.setText("File");
        this.jMainMenuItemFileExit.setToolTipText("Exits application");
        this.jMainMenuItemFileExit.setMnemonic('X');
        this.jMainMenuItemFileExit.setText("Exit");
        this.jMainMenuItemFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMainMenuItemFileExit_actionPerformed(e);
            }
        });
        this.jMenuEdit.setMnemonic('E');
        this.jMenuEdit.setText("Edit");
        this.jSplitPaneMain.setOrientation(0);
        this.jSplitPaneMain.setBackground(Color.lightGray);
        this.jSplitPaneMain.setLeftComponent(null);
        this.jSplitPaneMain.setRightComponent(null);
        this.jEditor.setText("");
        this.jEditor.setFont(new Font("Monospaced", 1, 12));
        this.jMenuDatabase.setMnemonic('D');
        this.jMenuDatabase.setText("Database");
        this.jMenuItemDatabaseConnect.setMnemonic('C');
        this.jMenuItemDatabaseConnect.setText("Connect...");
        this.jMenuItemDatabaseConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemDatabaseConnect_actionPerformed(e);
            }
        });
        this.jMenuItemDatabaseDisconnect.setMnemonic('S');
        this.jMenuItemDatabaseDisconnect.setText("Disconnect");
        this.jMenuItemDatabaseDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemDatabaseDisconnect_actionPerformed(e);
            }
        });
        this.jMenuItemDatabaseExecuteQuery.setEnabled(false);
        this.jMenuItemDatabaseExecuteQuery.setMnemonic('E');
        this.jMenuItemDatabaseExecuteQuery.setText("Execute current query");
        this.jMenuItemDatabaseExecuteQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemDatabaseExecuteQuery_actionPerformed(e);
            }
        });
        this.jMenuItem1.setEnabled(false);
        this.jMenuItem1.setMnemonic('T');
        this.jMenuItem1.setText("Cut");
        this.jMenuItem2.setEnabled(false);
        this.jMenuItem2.setMnemonic('C');
        this.jMenuItem2.setText("Copy");
        this.jMenuItem3.setEnabled(false);
        this.jMenuItem3.setMnemonic('P');
        this.jMenuItem3.setText("Paste");
        this.jMenuHelp.setMnemonic('H');
        this.jMenuHelp.setText("Help");
        this.jMenuItemHelpAbout.setMnemonic('A');
        this.jMenuItemHelpAbout.setText("About");
        this.jMenuItemHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemHelpAbout_actionPerformed(e);
            }
        });
        this.jMenu1.setMnemonic('V');
        this.jMenu1.setText("View");
        this.jCheckBoxMenuItemViewSizeColumnToLabel.setText("Size column to label");
        this.jCheckBoxMenuItemViewSizeColumnToLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jCheckBoxMenuItemViewSizeColumnToLabel_actionPerformed(e);
            }
        });
        this.jCheckBoxMenuItemDatabaseAutoCommit.setText("Auto commit");
        this.jCheckBoxMenuItemDatabaseAutoCommit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jCheckBoxMenuItemDatabaseAutoCommit_actionPerformed(e);
            }
        });
        this.jMenuItemDatabaseConnectViaList.setMnemonic('v');
        this.jMenuItemDatabaseConnectViaList.setText("Connect via list...");
        this.jMenuItemDatabaseConnectViaList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemDatabaseConnectViaList_actionPerformed(e);
            }
        });
        this.jMenuItemDatabaseExecuteUpdate.setEnabled(false);
        this.jMenuItemDatabaseExecuteUpdate.setText("Execute current update");
        this.jMenuItemDatabaseExecuteUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemDatabaseExecuteUpdate_actionPerformed(e);
            }
        });
        this.jMenuItemDatabaseExecuteQueryOrUpdate.setEnabled(false);
        this.jMenuItemDatabaseExecuteQueryOrUpdate.setActionCommand("Execute current query/update (CTRL+ENTER)");
        this.jMenuItemDatabaseExecuteQueryOrUpdate.setText("Execute current query/update (CTRL+ENTER)");
        this.jMenuItemDatabaseExecuteQueryOrUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemDatabaseExecuteQueryOrUpdate_actionPerformed(e);
            }
        });
        this.jMenuItemDatabaseExecuteWindow.setEnabled(false);
        this.jMenuItemDatabaseExecuteWindow.setText("Execute window as query/update");
        this.jMenuItemDatabaseExecuteWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemDatabaseExecuteWindow_actionPerformed(e);
            }
        });
        this.jMenuItemFileNew.setMnemonic('N');
        this.jMenuItemFileNew.setText("New");
        this.jMenuItemFileNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemFileNew_actionPerformed(e);
            }
        });
        this.jMenuItemFileOpen.setMnemonic('O');
        this.jMenuItemFileOpen.setText("Open...");
        this.jMenuItemFileOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemFileOpen_actionPerformed(e);
            }
        });
        this.jMenuItemSaveAs.setMnemonic('A');
        this.jMenuItemSaveAs.setText("Save As...");
        this.jMenuItemSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemSaveAs_actionPerformed(e);
            }
        });
        this.jMenuItemDatabaseSaveCurrentConnection.setText("Save current connection to list");
        this.jMenuItemDatabaseSaveCurrentConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemDatabaseSaveCurrentConnection_actionPerformed(e);
            }
        });
        this.jMenuItemDatabaseDataExport.setText("Data export...");
        this.jMenuItemDatabaseDataExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemDatabaseDataExport_actionPerformed(e);
            }
        });
        this.jCheckBoxMenuItemViewShowStackTrace.setText("Show exception stacktrace");
        this.jCheckBoxMenuItemViewShowStackTrace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jCheckBoxMenuItemViewShowStackTrace_actionPerformed(e);
            }
        });
        this.jMenuItemFileExecuteScript.setToolTipText("");
        this.jMenuItemFileExecuteScript.setText("Execute script...");
        this.jMenuItemFileExecuteScript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemFileExecuteScript_actionPerformed(e);
            }
        });
        this.jCheckBoxMenuItemViewShowException.setText("Show exception");
        this.jCheckBoxMenuItemViewShowException.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jCheckBoxMenuItemViewShowException_actionPerformed(e);
            }
        });
        this.jMenu2.setMnemonic('T');
        this.jMenu2.setText("Tools");
        this.jMenuItemToolsOptions.setMnemonic('O');
        this.jMenuItemToolsOptions.setText("Options");
        this.jMenuItemToolsOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jMenuItemToolsOptions_actionPerformed(e);
            }
        });
        this.jTextAreaResult.setBackground(Color.lightGray);
        this.jTextAreaResult.setText("[result area]");
        this.jTextAreaResult.setEditable(false);
        this.jTextAreaResult.setFont(new Font("Monospaced", 0, 12));
        this.jPanelResult.setLayout(this.borderLayout2);
        this.jSQLTableManagerPanel.setPreferredSize(new Dimension(1, 40));
        this.jCheckBoxMenuItemAutoSwitchToGrid.setText("Auto-switch to grid");
        this.jCheckBoxMenuItemAutoSwitchToGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TJADFrame.this.jCheckBoxMenuItemAutoSwitchToGrid_actionPerformed(e);
            }
        });
        this.jMainMenuBar.add(this.jMenuFile);
        this.jMainMenuBar.add(this.jMenuEdit);
        this.jMainMenuBar.add(this.jMenu1);
        this.jMainMenuBar.add(this.jMenuDatabase);
        this.jMainMenuBar.add(this.jMenu2);
        this.jMainMenuBar.add(this.jMenuHelp);
        this.jMenuFile.add(this.jMenuItemFileNew);
        this.jMenuFile.add(this.jMenuItemFileOpen);
        this.jMenuFile.add(this.jMenuItemSaveAs);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuItemFileExecuteScript);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMainMenuItemFileExit);
        this.jMenuDatabase.add(this.jMenuItemDatabaseExecuteQueryOrUpdate);
        this.jMenuDatabase.add(this.jMenuItemDatabaseExecuteQuery);
        this.jMenuDatabase.add(this.jMenuItemDatabaseExecuteUpdate);
        this.jMenuDatabase.addSeparator();
        this.jMenuDatabase.add(this.jMenuItemDatabaseExecuteWindow);
        this.jMenuDatabase.addSeparator();
        this.jMenuDatabase.add(this.jMenuItemDatabaseConnectViaList);
        this.jMenuDatabase.add(this.jMenuItemDatabaseSaveCurrentConnection);
        this.jMenuDatabase.addSeparator();
        this.jMenuDatabase.add(this.jMenuItemDatabaseConnect);
        this.jMenuDatabase.add(this.jMenuItemDatabaseDisconnect);
        this.jMenuDatabase.addSeparator();
        this.jMenuDatabase.add(this.jMenuItemDatabaseDataExport);
        this.jMenuDatabase.addSeparator();
        this.jMenuDatabase.add(this.jCheckBoxMenuItemDatabaseAutoCommit);
        this.getContentPane().add((Component)this.jSplitPaneMain, "Center");
        this.jSplitPaneMain.add((Component)this.jScrollPaneEdit, "top");
        this.jSplitPaneMain.add((Component)this.jTabbedPaneResult, "bottom");
        this.jTabbedPaneResult.add((Component)this.jScrollPaneTextResult, "Results");
        this.jTabbedPaneResult.add((Component)this.jPanelResult, "Grid");
        this.jPanelResult.add((Component)this.jScrollPaneTable, "Center");
        this.jPanelResult.add((Component)this.jSQLTableManagerPanel, "North");
        this.jScrollPaneTable.getViewport().add((Component)this.jTableResult, null);
        this.jScrollPaneTextResult.getViewport().add((Component)this.jTextAreaResult, null);
        this.jScrollPaneEdit.getViewport().add((Component)this.jEditor, null);
        this.jMenuEdit.add(this.jMenuItem1);
        this.jMenuEdit.add(this.jMenuItem2);
        this.jMenuEdit.add(this.jMenuItem3);
        this.jMenuHelp.add(this.jMenuItemHelpAbout);
        this.jMenu1.add(this.jCheckBoxMenuItemViewSizeColumnToLabel);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.jCheckBoxMenuItemViewShowException);
        this.jMenu1.add(this.jCheckBoxMenuItemViewShowStackTrace);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.jCheckBoxMenuItemAutoSwitchToGrid);
        this.jMenu2.add(this.jMenuItemToolsOptions);
        this.jMenu2.add(this.jMenuItem4);
        this.jSplitPaneMain.setDividerLocation(100);
    }

    void jMainMenuItemFileExit_actionPerformed(ActionEvent e) {
        this.saveConfigFile();
        this.dispose();
        System.exit(1);
    }

    void jMenuItemDatabaseConnect_actionPerformed(ActionEvent e) {
        DatabaseParamsDlg dlg = new DatabaseParamsDlg((Frame)this, "Connect to database");
        if (this.lastConnectionEntry != null) {
            dlg.setJDBCDriver(this.lastConnectionEntry.strJdbcDriver);
            dlg.jTextFieldUser.setText(this.lastConnectionEntry.strUser);
            ((JTextComponent)dlg.jPasswordFieldPassword).setText(this.lastConnectionEntry.strPassword);
            dlg.setJDBCURL(this.lastConnectionEntry.strJdbcUrl);
        }
        dlg.show();
        if (dlg.strResult.equals("OK")) {
            String strJdbcDriver = dlg.getJDBCDriver();
            String strUser = dlg.jTextFieldUser.getText();
            String strPassword = new String(dlg.jPasswordFieldPassword.getPassword());
            String strJdbcUrl = dlg.getJDBCURL();
            ConnectionEntry ce = new ConnectionEntry(strJdbcUrl, strUser, strPassword, strJdbcDriver);
            this.openDatabaseConnection(ce);
        }
    }

    void jMenuItemDatabaseExecuteQuery_actionPerformed(ActionEvent e) {
        String strQuery = "";
        strQuery = this.sqlEditor.getCurrentCommand();
        this.executeSelectSQL(strQuery);
    }

    public String rpad(String str, int iLen) {
        return this.rpad(str, iLen, ' ');
    }

    public String rpad(String str, int iLen, char c) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= iLen) {
            str = str.substring(0, iLen);
            return str;
        }
        while (str.length() < iLen) {
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(c)));
        }
        return str;
    }

    public Connection connectToDatabase(String strJdbcUrl, String strUser, String strPassword) {
        try {
            if (strUser != null && !strUser.equals("")) {
                Connection connection = DriverManager.getConnection(strJdbcUrl, strUser, strPassword);
                return connection;
            }
            Connection connection = DriverManager.getConnection(strJdbcUrl);
            return connection;
        }
        catch (Exception e) {
            this.showException("Failed to open connection", e);
            Connection connection = null;
            return connection;
        }
    }

    public boolean registerJdbcDriver(String strJdbcDriver) {
        try {
            Driver driver = (Driver)Class.forName(strJdbcDriver).newInstance();
            DriverManager.registerDriver(driver);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.showException("Failed to register JDBC driver", e);
            boolean bl = false;
            return bl;
        }
    }

    private void setAutoCommit() {
        if (this.connection == null) {
            MessageDialog d = new MessageDialog((Frame)this, "ERROR", "No opened connection.", "");
            d.show();
        } else {
            try {
                try {
                    this.connection.setAutoCommit(this.bAutoCommit);
                }
                catch (Exception ee) {
                    MessageDialog d = new MessageDialog((Frame)this, "WARNING", "Failed to set autocommit to ".concat(String.valueOf(String.valueOf(this.bAutoCommit))), ee.getMessage());
                    d.show();
                }
                this.statement = this.connection.createStatement();
            }
            catch (SQLException e) {
                e.printStackTrace();
                MessageDialog d = new MessageDialog((Frame)this, "ERROR", "Can not open connection.", "Bad JDBC URL.");
                d.show();
            }
        }
    }

    void jMenuItemDatabaseDisconnect_actionPerformed(ActionEvent e) {
        this.disconnectFromDatabase();
        this.jTextAreaResult.setText("Disconnected from database...");
        this.updateDisplay();
    }

    private void disconnectFromDatabase() {
        if (this.connection != null) {
            try {
                this.statement.close();
                this.statement = null;
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException ee) {
                ee.printStackTrace();
                MessageDialog d = new MessageDialog((Frame)this, "WARNING", "Failed to close connection", "");
                d.show();
            }
        }
    }

    void this_keyPressed(KeyEvent e) {
        int iModifiers = e.getModifiers();
        if ((iModifiers & 2) > 0 && e.getKeyCode() == 10) {
            this.jMenuItemDatabaseExecuteQueryOrUpdate_actionPerformed(null);
        }
    }

    void jMenuItemHelpAbout_actionPerformed(ActionEvent e) {
        MessageDialog d = new MessageDialog((Frame)this, "ABOUT", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strAPP_NAME))).append(" ").append(strAPP_VERSION).append(", ").append(strAPP_COPYRIGHT))), "http://www.tomaskovic.com");
        d.show();
    }

    void jCheckBoxMenuItemViewSizeColumnToLabel_actionPerformed(ActionEvent e) {
        this.bSizeColumnToLabel = this.jCheckBoxMenuItemViewSizeColumnToLabel.getState();
    }

    private void updateDisplay() {
        if (this.connection != null && this.statement != null) {
            this.jEditor.setEditable(true);
            this.jEditor.setBackground(Color.white);
            this.jMenuItemDatabaseExecuteQuery.setEnabled(true);
            this.jMenuItemDatabaseExecuteUpdate.setEnabled(true);
            this.jMenuItemDatabaseExecuteQueryOrUpdate.setEnabled(true);
            this.jMenuItemDatabaseExecuteWindow.setEnabled(true);
            this.jMenuItemDatabaseSaveCurrentConnection.setEnabled(true);
            this.jMenuItemDatabaseConnect.setEnabled(false);
            this.jMenuItemDatabaseDisconnect.setEnabled(true);
            this.jMenuItemDatabaseDataExport.setEnabled(true);
            this.jCheckBoxMenuItemDatabaseAutoCommit.setEnabled(true);
        } else {
            this.jEditor.setEditable(false);
            this.jEditor.setBackground(Color.lightGray);
            this.jMenuItemDatabaseExecuteQuery.setEnabled(false);
            this.jMenuItemDatabaseExecuteUpdate.setEnabled(false);
            this.jMenuItemDatabaseExecuteQueryOrUpdate.setEnabled(false);
            this.jMenuItemDatabaseExecuteWindow.setEnabled(false);
            this.jMenuItemDatabaseSaveCurrentConnection.setEnabled(false);
            this.jMenuItemDatabaseConnect.setEnabled(true);
            this.jMenuItemDatabaseDisconnect.setEnabled(false);
            this.jMenuItemDatabaseDataExport.setEnabled(false);
            this.jCheckBoxMenuItemDatabaseAutoCommit.setEnabled(false);
        }
        this.jCheckBoxMenuItemViewSizeColumnToLabel.setState(this.bSizeColumnToLabel);
        this.jCheckBoxMenuItemDatabaseAutoCommit.setState(this.bAutoCommit);
        this.jCheckBoxMenuItemViewShowException.setState(this.bShowException);
        this.jCheckBoxMenuItemViewShowStackTrace.setState(this.bShowExceptionStackTrace);
        this.jCheckBoxMenuItemAutoSwitchToGrid.setState(this.bAutoSwitchToGrid);
    }

    void jCheckBoxMenuItemDatabaseAutoCommit_actionPerformed(ActionEvent e) {
        this.bAutoCommit = this.jCheckBoxMenuItemDatabaseAutoCommit.getState();
        this.setAutoCommit();
    }

    void jMenuItemDatabaseConnectViaList_actionPerformed(ActionEvent e) {
        ConnectionEntry ce;
        ConnectionListDlg d = new ConnectionListDlg((Frame)this, "Choose database connection", true, this.vConnectionEntries);
        d.show();
        this.saveConfigFile();
        if (d.strResult.equals("Select") && (ce = d.tm.getSelectedEntry()) != null) {
            this.openDatabaseConnection(ce);
        }
    }

    private void loadConfigFile() {
        Properties prop = new Properties();
        try {
            String strJdbcUrl;
            FileInputStream fis = new FileInputStream(this.strConfigFilename);
            prop.load(fis);
            fis.close();
            int i = 0;
            while ((strJdbcUrl = prop.getProperty("JDBC_URL_".concat(String.valueOf(String.valueOf(i))))) != null) {
                String strUser = prop.getProperty("USER_".concat(String.valueOf(String.valueOf(i))));
                String strPassword = prop.getProperty("PASSWORD_".concat(String.valueOf(String.valueOf(i))));
                String strJdbcDriver = prop.getProperty("JDBC_DRIVER_".concat(String.valueOf(String.valueOf(i))));
                ConnectionEntry e = new ConnectionEntry(strJdbcUrl, strUser, strPassword, strJdbcDriver);
                this.vConnectionEntries.add(e);
                ++i;
            }
            this.strLastPath = prop.getProperty("LAST_PATH");
            if (this.strLastPath == null) {
                this.strLastPath = ".";
            }
            this.bShowExceptionStackTrace = this.getBooleanProp(prop, "SHOW_EXCEPTION_STACKTRACE", false);
            this.bShowException = this.getBooleanProp(prop, "SHOW_EXCEPTION", true);
            this.bAutoSwitchToGrid = this.getBooleanProp(prop, "AutoSwitchToGrid", false);
            this.bLimitRowsToFetch = this.getBooleanProp(prop, "LIMIT_ROWS_TO_FETCH", true);
            this.iRowsToFetch = this.getIntProp(prop, "ROWS_TO_FETCH", 20);
            this.iInitialTab = this.getIntProp(prop, "INITIAL_TAB", 0);
            this.iDividerLocation = this.getIntProp(prop, "DividerLocation", 100);
        }
        catch (IOException eee) {
            MessageDialog d = new MessageDialog((Frame)this, "WARNING", "Failed to load configuration file", String.valueOf(String.valueOf(new StringBuffer("'").append(this.strConfigFilename).append("'"))));
            d.show();
        }
    }

    private boolean getBooleanProp(Properties p, String strPropName, boolean bDefaultValue) {
        String s = p.getProperty(strPropName);
        if (s == null) {
            return bDefaultValue;
        }
        boolean b = s.equals("YES");
        return b;
    }

    private void setBooleanProp(Properties p, String strPropName, boolean bPropValue) {
        String s = bPropValue ? "YES" : "NO";
        p.setProperty(strPropName, s);
    }

    private int getIntProp(Properties p, String strPropName, int iDefaultValue) {
        String strValue = p.getProperty(strPropName);
        if (strValue == null) {
            return iDefaultValue;
        }
        try {
            int iVal;
            int n = iVal = Integer.valueOf(strValue).intValue();
            return n;
        }
        catch (NumberFormatException e) {
            int n = iDefaultValue;
            return n;
        }
    }

    private void setIntProp(Properties p, String strPropName, int iPropValue) {
        p.setProperty(strPropName, "".concat(String.valueOf(String.valueOf(iPropValue))));
    }

    private void saveConfigFile() {
        Properties prop = new Properties();
        try {
            for (int i = 0; i < this.vConnectionEntries.size(); ++i) {
                ConnectionEntry e = (ConnectionEntry)this.vConnectionEntries.get(i);
                prop.setProperty("JDBC_URL_".concat(String.valueOf(String.valueOf(i))), e.strJdbcUrl);
                prop.setProperty("USER_".concat(String.valueOf(String.valueOf(i))), e.strUser);
                prop.setProperty("PASSWORD_".concat(String.valueOf(String.valueOf(i))), e.strPassword);
                prop.setProperty("JDBC_DRIVER_".concat(String.valueOf(String.valueOf(i))), e.strJdbcDriver);
            }
            prop.setProperty("LAST_PATH", this.strLastPath);
            this.setBooleanProp(prop, "SHOW_EXCEPTION_STACKTRACE", this.bShowExceptionStackTrace);
            this.setBooleanProp(prop, "SHOW_EXCEPTION", this.bShowException);
            this.setBooleanProp(prop, "AutoSwitchToGrid", this.bAutoSwitchToGrid);
            this.setBooleanProp(prop, "LIMIT_ROWS_TO_FETCH", this.bLimitRowsToFetch);
            this.setIntProp(prop, "ROWS_TO_FETCH", this.iRowsToFetch);
            this.iInitialTab = this.jTabbedPaneResult.getSelectedIndex();
            this.setIntProp(prop, "INITIAL_TAB", this.iInitialTab);
            this.setIntProp(prop, "DividerLocation", this.jSplitPaneMain.getDividerLocation());
            FileOutputStream fos = new FileOutputStream(this.strConfigFilename);
            prop.store(fos, "TJAD config file");
            fos.close();
        }
        catch (IOException eee) {
            MessageDialog d = new MessageDialog((Frame)this, "WARNING", "Failed to save configuration file", String.valueOf(String.valueOf(new StringBuffer("'").append(this.strConfigFilename).append("'"))));
            d.show();
        }
    }

    private void openDatabaseConnection(ConnectionEntry e) {
        this.lastConnectionEntry = e;
        this.jTextAreaResult.setText("Connecting...");
        this.jTextAreaResult.updateUI();
        this.disconnectFromDatabase();
        if (this.htDrivers.get(e.strJdbcDriver) == null) {
            if (this.registerJdbcDriver(e.strJdbcDriver)) {
                this.htDrivers.put(e.strJdbcDriver, "DRIVER");
            } else {
                return;
            }
        }
        this.connection = this.connectToDatabase(e.strJdbcUrl, e.strUser, e.strPassword);
        if (this.connection != null) {
            this.jTextAreaResult.setText("Connected to database...");
            this.setAutoCommit();
            this.updateDisplay();
        }
    }

    void jMenuItemDatabaseExecuteUpdate_actionPerformed(ActionEvent e) {
        String strQuery = "";
        strQuery = this.sqlEditor.getCurrentCommand();
        this.executeUpdateSQL(strQuery);
    }

    void jMenuItemDatabaseExecuteQueryOrUpdate_actionPerformed(ActionEvent e) {
        String strQuery = "";
        strQuery = this.sqlEditor.getCurrentCommand();
        this.executeSelectOrUpdateSQL(strQuery);
    }

    private void executeUpdateSQL(String strSQL) {
        if ((strSQL = strSQL.trim()).equals("")) {
            this.showSQLException("No SQL update command", null);
            return;
        }
        if (this.statement == null) {
            this.showSQLException("No opened connection.", null);
            return;
        }
        String str = "";
        try {
            int iResult = this.statement.executeUpdate(strSQL);
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("Result: ".concat(String.valueOf(String.valueOf(iResult))))));
            this.showSQLResult(strSQL, str);
        }
        catch (SQLException ee) {
            this.showSQLException(strSQL, ee);
        }
    }

    private String doExecuteUpdateSQL(String strSQL) {
        if ((strSQL = strSQL.trim()).equals("")) {
            return "No SQL update command";
        }
        if (this.statement == null) {
            return "No opened connection.";
        }
        String str = "";
        try {
            int iResult = this.statement.executeUpdate(strSQL);
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(strSQL)));
            str = String.valueOf(String.valueOf(str)).concat("\n--(UPDATE COMMAND)-------------------------------\n");
            String string = str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("Result: ".concat(String.valueOf(String.valueOf(iResult))))));
            return string;
        }
        catch (SQLException ee) {
            String string = this.getToShowException(strSQL, ee);
            return string;
        }
    }

    private String doExecuteSelectSQL(String strSQL) {
        if (strSQL.equals("")) {
            return "No SQL command";
        }
        if (this.statement == null) {
            return "No opened connection.";
        }
        try {
            int i;
            ResultSet resultset = this.statement.executeQuery(strSQL);
            ResultSetMetaData m = resultset.getMetaData();
            String str = "";
            int iColumnCount = m.getColumnCount();
            int[] iColumnDisplaySize = new int[iColumnCount];
            for (i = 1; i < iColumnCount + 1; ++i) {
                iColumnDisplaySize[i - 1] = this.bSizeColumnToLabel ? m.getColumnLabel(i).length() : m.getColumnDisplaySize(i);
            }
            String strHeader = "";
            String strHeaderLine = "";
            for (i = 1; i < iColumnCount + 1; ++i) {
                strHeader = String.valueOf(String.valueOf(strHeader)).concat(String.valueOf(String.valueOf(this.rpad(m.getColumnLabel(i), iColumnDisplaySize[i - 1]))));
                strHeaderLine = String.valueOf(String.valueOf(strHeaderLine)).concat(String.valueOf(String.valueOf(this.rpad("", iColumnDisplaySize[i - 1], '-'))));
                if (i >= iColumnCount) continue;
                strHeader = String.valueOf(String.valueOf(strHeader)).concat(" ");
                strHeaderLine = String.valueOf(String.valueOf(strHeaderLine)).concat(" ");
            }
            String strFullHeaderLine = this.rpad("", strHeader.length(), '-');
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(strFullHeaderLine)));
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(strHeader))))));
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(strHeaderLine))))));
            int iRowCount = 0;
            while (resultset.next()) {
                if (this.bLimitRowsToFetch && iRowCount > this.iRowsToFetch) {
                    str = String.valueOf(String.valueOf(str)).concat("\n ..stopped (has more rows)");
                    break;
                }
                String strRow = "";
                for (i = 1; i < iColumnCount + 1; ++i) {
                    strRow = String.valueOf(String.valueOf(strRow)).concat(String.valueOf(String.valueOf(this.rpad(resultset.getString(i), iColumnDisplaySize[i - 1]))));
                    if (i >= iColumnCount) continue;
                    strRow = String.valueOf(String.valueOf(strRow)).concat(" ");
                }
                str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(strRow))))));
                ++iRowCount;
            }
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(strFullHeaderLine))))));
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("\n").append(iRowCount).append(" total rows..."))))));
            String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(strRESULT_SEPARATOR).append(str)));
            return string;
        }
        catch (SQLException ee) {
            String string = this.getToShowException(strSQL, ee);
            return string;
        }
    }

    private void executeSelectSQL(String strSQL) {
        if (strSQL.equals("")) {
            this.showSQLException("No SQL command", null);
            return;
        }
        if (this.statement == null) {
            this.showSQLException("No opened connection.", null);
            return;
        }
        try {
            int i;
            ResultSet resultset = this.statement.executeQuery(strSQL);
            ResultSetMetaData m = resultset.getMetaData();
            String str = "";
            int iColumnCount = m.getColumnCount();
            int[] iColumnDisplaySize = new int[iColumnCount];
            for (i = 1; i < iColumnCount + 1; ++i) {
                iColumnDisplaySize[i - 1] = this.bSizeColumnToLabel ? m.getColumnLabel(i).length() : m.getColumnDisplaySize(i);
            }
            String strHeader = "";
            String strHeaderLine = "";
            for (i = 1; i < iColumnCount + 1; ++i) {
                strHeader = String.valueOf(String.valueOf(strHeader)).concat(String.valueOf(String.valueOf(this.rpad(m.getColumnLabel(i), iColumnDisplaySize[i - 1]))));
                strHeaderLine = String.valueOf(String.valueOf(strHeaderLine)).concat(String.valueOf(String.valueOf(this.rpad("", iColumnDisplaySize[i - 1], '-'))));
                if (i >= iColumnCount) continue;
                strHeader = String.valueOf(String.valueOf(strHeader)).concat(" ");
                strHeaderLine = String.valueOf(String.valueOf(strHeaderLine)).concat(" ");
            }
            String strFullHeaderLine = this.rpad("", strHeader.length(), '-');
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(strFullHeaderLine)));
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(strHeader))))));
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(strHeaderLine))))));
            int iRowCount = 0;
            while (resultset.next()) {
                if (this.bLimitRowsToFetch && iRowCount > this.iRowsToFetch) {
                    str = String.valueOf(String.valueOf(str)).concat("\n ..stopped (has more rows)");
                    break;
                }
                String strRow = "";
                for (i = 1; i < iColumnCount + 1; ++i) {
                    strRow = String.valueOf(String.valueOf(strRow)).concat(String.valueOf(String.valueOf(this.rpad(resultset.getString(i), iColumnDisplaySize[i - 1]))));
                    if (i >= iColumnCount) continue;
                    strRow = String.valueOf(String.valueOf(strRow)).concat(" ");
                }
                str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(strRow))))));
                ++iRowCount;
            }
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(strFullHeaderLine))))));
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("\n").append(iRowCount).append(" total rows..."))))));
            this.showSQLResult(strSQL, str);
        }
        catch (SQLException ee) {
            this.showSQLException(strSQL, ee);
        }
    }

    private void executeSelectOrUpdateSQL(String strSQL) {
        if ((strSQL = strSQL.trim()).length() >= "select".length() && strSQL.substring(0, "select".length()).toLowerCase().equals("select")) {
            int iIndex = this.jTabbedPaneResult.getSelectedIndex();
            if (this.bAutoSwitchToGrid && iIndex != 1) {
                this.jTabbedPaneResult.setSelectedIndex(1);
                iIndex = 1;
            }
            if (iIndex == 1) {
                this.sqlTableManager.setQuery(strSQL, this.connection);
                return;
            }
            this.executeSelectSQL(strSQL);
            return;
        }
        int iIndex = this.jTabbedPaneResult.getSelectedIndex();
        if (this.bAutoSwitchToGrid && iIndex != 0) {
            this.jTabbedPaneResult.setSelectedIndex(0);
        }
        this.executeUpdateSQL(strSQL);
    }

    void jMenuItemDatabaseExecuteWindow_actionPerformed(ActionEvent e) {
        String str = "";
        this.jTabbedPaneResult.setSelectedIndex(0);
        String strQuery = "";
        strQuery = this.sqlEditor.getFirstCommand();
        while (!strQuery.equals("")) {
            str = String.valueOf(String.valueOf(str)).concat("\n*** COMMAND **********************************************************\n");
            String strSQL = strQuery.trim();
            String strResult = strSQL.length() >= "select".length() ? (strSQL.substring(0, "select".length()).toLowerCase().equals("select") ? this.doExecuteSelectSQL(strSQL) : this.doExecuteUpdateSQL(strSQL)) : this.doExecuteUpdateSQL(strSQL);
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(strResult)).concat("\n\n"))));
            strQuery = this.sqlEditor.getNextCommand();
        }
        this.jTextAreaResult.setText(str);
    }

    void jMenuItemFileNew_actionPerformed(ActionEvent e) {
        this.jEditor.setText("");
    }

    void jMenuItemFileOpen_actionPerformed(ActionEvent e) {
        FileDialog fd = new FileDialog((Frame)this, "Load SQL script", 0);
        fd.setDirectory(this.strLastPath);
        fd.show();
        String strFile = fd.getFile();
        if (strFile != null) {
            this.strLastPath = fd.getDirectory();
            String str = "";
            try {
                int l;
                FileReader fr = new FileReader(Path.mergePathAndName(this.strLastPath, strFile));
                while ((l = fr.read()) != -1) {
                    str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf((char)l)));
                }
                fr.close();
                this.jEditor.setText(str);
                this.jTextAreaResult.setText("Loaded...");
            }
            catch (Exception ee) {
                this.showException("Failed loading file", ee);
            }
        }
    }

    void jMenuItemSaveAs_actionPerformed(ActionEvent e) {
        FileDialog fd = new FileDialog((Frame)this, "Save SQL script", 1);
        fd.setDirectory(this.strLastPath);
        fd.show();
        String strFile = fd.getFile();
        if (strFile != null) {
            this.strLastPath = fd.getDirectory();
            try {
                FileWriter fw = new FileWriter(Path.mergePathAndName(this.strLastPath, strFile));
                boolean i = false;
                String str = this.jEditor.getText();
                fw.write(str);
                fw.close();
                this.jTextAreaResult.setText("File saved");
            }
            catch (Exception ee) {
                this.showException("Failed saving", ee);
            }
        }
    }

    void jMenuItemDatabaseSaveCurrentConnection_actionPerformed(ActionEvent e) {
        if (this.lastConnectionEntry != null) {
            this.vConnectionEntries.add(this.lastConnectionEntry);
        }
        this.saveConfigFile();
    }

    void jMenuItemDatabaseDataExport_actionPerformed(ActionEvent e) {
        block12: {
            String strQuery = "";
            strQuery = this.sqlEditor.getCurrentCommand();
            ExportTableDlg dlg = new ExportTableDlg((Frame)this, strQuery);
            dlg.show();
            if (!dlg.strResult.equals("Ok")) break block12;
            String strTargetFilename = dlg.jTextFieldTargetFilename.getText();
            String strTargetTable = dlg.jTextFieldTargetTable.getText();
            strQuery = dlg.jTextAreaQuery.getText().trim();
            try {
                FileWriter fw = new FileWriter(strTargetFilename);
                try {
                    ResultSet resultset = this.statement.executeQuery(strQuery);
                    ResultSetMetaData m = resultset.getMetaData();
                    int iColumnCount = m.getColumnCount();
                    while (resultset.next()) {
                        String strValues = "";
                        for (int i = 1; i < iColumnCount + 1; ++i) {
                            String strValue;
                            int iType;
                            if (i > 1) {
                                strValues = String.valueOf(String.valueOf(strValues)).concat(", ");
                            }
                            if ((iType = m.getColumnType(i)) == 2 || iType == 4) {
                                strValues = String.valueOf(String.valueOf(strValues)).concat(String.valueOf(String.valueOf(resultset.getInt(i))));
                                continue;
                            }
                            if (iType == 1 || iType == 12) {
                                strValue = resultset.getString(i);
                                if (strValue == null) {
                                    strValues = String.valueOf(String.valueOf(strValues)).concat("null");
                                    continue;
                                }
                                strValues = String.valueOf(String.valueOf(strValues)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("'").append(strValue).append("'"))))));
                                continue;
                            }
                            if (iType == 93) {
                                Date d = resultset.getDate(i);
                                if (d == null) {
                                    strValues = String.valueOf(String.valueOf(strValues)).concat("null");
                                    continue;
                                }
                                GregorianCalendar c = new GregorianCalendar();
                                c.setTime(d);
                                strValues = String.valueOf(String.valueOf(strValues)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("to_date('").append(c.get(5)).append(".").append(c.get(2)).append(".").append(c.get(1)).append(" ").append(c.get(10)).append(":").append(c.get(12)).append(":").append(c.get(13)).append("', 'dd.mm.yyyy hh24:mi:ss')"))))));
                                continue;
                            }
                            strValue = resultset.getString(i);
                            strValues = strValue == null ? String.valueOf(String.valueOf(strValues)).concat("null") : String.valueOf(String.valueOf(strValues)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("'").append(strValue).append("'"))))));
                        }
                        fw.write(String.valueOf(String.valueOf(new StringBuffer("INSERT INTO ").append(strTargetTable).append(" VALUES (").append(strValues).append(");").append("\n\n"))));
                    }
                }
                catch (SQLException se) {
                    this.showException("Failed fetching data", se);
                    fw.close();
                    return;
                }
                fw.close();
                this.jTextAreaResult.setText("Data export finished.");
            }
            catch (IOException ioe) {
                this.showException("Failed saving data", ioe);
            }
        }
    }

    void jCheckBoxMenuItemViewShowStackTrace_actionPerformed(ActionEvent e) {
        this.bShowExceptionStackTrace = this.jCheckBoxMenuItemViewShowStackTrace.getState();
    }

    private void showException(String strDescription, Exception e) {
        this.jTextAreaResult.setText(this.getToShowException(strDescription, e));
    }

    private String getToShowException(String strDescription, Exception e) {
        String s = "";
        if (!strDescription.equals("")) {
            s = String.valueOf(String.valueOf(strDescription)).concat("\n");
        }
        if (!this.bShowExceptionStackTrace && this.bShowException) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(e.toString())));
        } else if (this.bShowExceptionStackTrace) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(baos.toString())));
        }
        return s;
    }

    void jMenuItemFileExecuteScript_actionPerformed(ActionEvent e) {
        FileDialog fd = new FileDialog((Frame)this, "Select SQL script", 0);
        fd.setDirectory(this.strLastPath);
        fd.show();
        String strFile = fd.getFile();
        if (strFile != null) {
            this.strLastPath = fd.getDirectory();
            String str = "";
            SQLScript script = new SQLScript(new File(Path.mergePathAndName(this.strLastPath, strFile)));
            if (script.execute(this.connection, this.bAutoCommit, true)) {
                this.jTextAreaResult.setText("Script processed");
            } else {
                this.jTextAreaResult.setText("Failed processing script");
            }
        }
    }

    void jCheckBoxMenuItemViewShowException_actionPerformed(ActionEvent e) {
        this.bShowException = this.jCheckBoxMenuItemViewShowException.getState();
    }

    void jMenuItemToolsOptions_actionPerformed(ActionEvent e) {
        TjadOptionsDlg dlg = new TjadOptionsDlg(this);
        dlg.jTextFieldRowsToFetch.setText("".concat(String.valueOf(String.valueOf(this.iRowsToFetch))));
        dlg.jCheckBoxLimitRowsToFetch.setSelected(this.bLimitRowsToFetch);
        dlg.show();
        if (dlg.strResult.equals("Ok")) {
            String strRowsToFetch = dlg.jTextFieldRowsToFetch.getText();
            this.iRowsToFetch = Integer.valueOf(strRowsToFetch);
            this.bLimitRowsToFetch = dlg.jCheckBoxLimitRowsToFetch.isSelected();
            this.sqlTableManager.setRowsToFetch(this.iRowsToFetch);
        }
        this.saveConfigFile();
    }

    public void dispose() {
        this.saveConfigFile();
        super.dispose();
    }

    public void executeSQL(String strSQL) {
        strSQL = strSQL.trim();
        strSQL = SQLEditor.removeTrailingSemicolonFromSQL(strSQL);
        this.jTabbedPaneResult.setSelectedIndex(0);
        this.executeSelectOrUpdateSQL(strSQL);
    }

    public void showSQLException(String strSQL, SQLException e) {
        if (e == null) {
            this.jTextAreaResult.setText(strSQL);
        } else {
            this.jTextAreaResult.setText(this.getToShowException(strSQL, e));
        }
        if (this.jTabbedPaneResult.getSelectedIndex() != 0) {
            this.jTabbedPaneResult.setSelectedIndex(0);
        }
    }

    public void showSQLResult(String strSQL, String strResult) {
        if (strSQL != null && strSQL.length() > 0) {
            this.jTextAreaResult.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strSQL))).append(strRESULT_SEPARATOR).append(strResult))));
        } else {
            this.jTextAreaResult.setText(strResult);
        }
    }

    void jCheckBoxMenuItemAutoSwitchToGrid_actionPerformed(ActionEvent e) {
        this.bAutoSwitchToGrid = this.jCheckBoxMenuItemAutoSwitchToGrid.getState();
    }

    static {
        strRESULT_SEPARATOR = strRESULT_SEPARATOR;
        TAB_TEXTAREA = 0;
        TAB_GRID = 1;
    }
}

