/*
 * Decompiled with CFR 0.152.
 */
package com.tomaskovic.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Path {
    public static void log(String strText) {
        System.out.println(strText);
    }

    public static String mergePathAndName(String strPath, String strName) {
        if (strPath == null) {
            strPath = "";
        }
        strPath.trim();
        if (strName == null) {
            strName = "";
        }
        strName.trim();
        String strSeparator = strPath.indexOf(File.separator) != -1 ? File.separator : (strPath.indexOf("/") != -1 ? "/" : (strPath.indexOf("\\") != -1 ? "\\" : File.separator));
        if (strPath.length() > 0 && !strPath.substring(strPath.length() - 1, strPath.length()).equals(strSeparator)) {
            strPath = String.valueOf(String.valueOf(strPath)).concat(String.valueOf(String.valueOf(strSeparator)));
        }
        if (strName.length() > 0 && strName.substring(0, 1).equals(strSeparator)) {
            strName = strName.substring(1, strName.length());
        }
        String strPathAndName = String.valueOf(String.valueOf(strPath)).concat(String.valueOf(String.valueOf(strName)));
        return strPathAndName;
    }

    public static String getOnlyFilename(String strPathFilename) {
        if (strPathFilename == null) {
            strPathFilename = "";
        }
        strPathFilename.trim();
        String strSeparator = strPathFilename.indexOf(File.separator) != -1 ? File.separator : (strPathFilename.indexOf("/") != -1 ? "/" : (strPathFilename.indexOf("\\") != -1 ? "\\" : File.separator));
        int iLastIndex = strPathFilename.lastIndexOf(strSeparator);
        if (iLastIndex == -1) {
            return strPathFilename;
        }
        return strPathFilename.substring(iLastIndex + 1);
    }

    public static void copyFolder(String strSrcFolder, String strDestFolder) {
        try {
            File fSrc = new File(strSrcFolder);
            String strNewDest = Path.mergePathAndName(strDestFolder, fSrc.getName());
            File fCopyDest = new File(strNewDest);
            if (!fCopyDest.exists()) {
                fCopyDest.mkdirs();
            }
            String[] strFileList = fSrc.list();
            for (int i = 0; i < strFileList.length; ++i) {
                String strFullSrcPath = Path.mergePathAndName(strSrcFolder, strFileList[i]);
                File f = new File(strFullSrcPath);
                if (f.isFile()) {
                    Path.copyFile(strFullSrcPath, Path.mergePathAndName(strNewDest, strFileList[i]));
                    continue;
                }
                if (!f.isDirectory()) continue;
                Path.copyFolder(strFullSrcPath, strNewDest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(String strSrcFile, String strDestFile) {
        try {
            int l;
            FileOutputStream fos = new FileOutputStream(strDestFile);
            FileInputStream fis = new FileInputStream(strSrcFile);
            byte[] buffer = new byte[4096];
            while ((l = fis.read(buffer, 0, 4096)) != -1) {
                fos.write(buffer, 0, l);
            }
            fis.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

